"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MaxLinesInput = exports.LegendSettingsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _toolbar_popover = require("../toolbar_popover");
var _legend_location_settings = require("./location/legend_location_settings");
var _columns_number_setting = require("./layout/columns_number_setting");
var _legend_size_settings = require("./size/legend_size_settings");
var _debounced_value = require("../debounced_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TRUNCATE_LINES = 1;
const MAX_TRUNCATE_LINES = 5;
const MIN_TRUNCATE_LINES = 1;
const MaxLinesInput = ({
  value,
  setValue
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _debounced_value.useDebouncedValue)({
    value,
    onChange: setValue
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "lens-legend-max-lines-input",
    value: inputValue,
    min: MIN_TRUNCATE_LINES,
    max: MAX_TRUNCATE_LINES,
    step: 1,
    compressed: true,
    onChange: e => {
      const val = Number(e.target.value);
      // we want to automatically change the values to the limits
      // if the user enters a value that is outside the limits
      handleInputChange(Math.min(MAX_TRUNCATE_LINES, Math.max(val, MIN_TRUNCATE_LINES)));
    }
  });
};
exports.MaxLinesInput = MaxLinesInput;
const noop = () => {};
const LegendSettingsPopover = ({
  legendOptions,
  mode,
  onDisplayChange,
  position,
  location,
  onLocationChange = noop,
  verticalAlignment,
  horizontalAlignment,
  floatingColumns,
  onAlignmentChange = noop,
  onFloatingColumnsChange = noop,
  onPositionChange,
  renderNestedLegendSwitch,
  nestedLegend,
  onNestedLegendChange = noop,
  valueInLegend,
  onValueInLegendChange = noop,
  renderValueInLegendSwitch,
  groupPosition = 'right',
  maxLines,
  onMaxLinesChange = noop,
  shouldTruncate,
  onTruncateLegendChange = noop,
  legendSize,
  onLegendSizeChange,
  showAutoLegendSizeOption
}) => {
  return /*#__PURE__*/_react.default.createElement(_toolbar_popover.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.shared.legendLabel', {
      defaultMessage: 'Legend'
    }),
    type: "legend",
    groupPosition: groupPosition,
    buttonDataTestSubj: "lnsLegendButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.shared.legendVisibilityLabel', {
      defaultMessage: 'Display'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: _i18n.i18n.translate('xpack.lens.shared.legendVisibilityLabel', {
      defaultMessage: 'Display'
    }),
    "data-test-subj": "lens-legend-display-btn",
    name: "legendDisplay",
    buttonSize: "compressed",
    options: legendOptions,
    idSelected: legendOptions.find(({
      value
    }) => value === mode).id,
    onChange: onDisplayChange
  })), mode !== 'hide' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_legend_location_settings.LegendLocationSettings, {
    location: location,
    onLocationChange: onLocationChange,
    verticalAlignment: verticalAlignment,
    horizontalAlignment: horizontalAlignment,
    onAlignmentChange: onAlignmentChange,
    position: position,
    onPositionChange: onPositionChange
  }), location !== 'inside' && /*#__PURE__*/_react.default.createElement(_legend_size_settings.LegendSizeSettings, {
    legendSize: legendSize,
    onLegendSizeChange: onLegendSizeChange,
    isVerticalLegend: !position || position === _charts.Position.Left || position === _charts.Position.Right,
    showAutoOption: showAutoLegendSizeOption
  }), location && /*#__PURE__*/_react.default.createElement(_columns_number_setting.ColumnsNumberSetting, {
    floatingColumns: floatingColumns,
    onFloatingColumnsChange: onFloatingColumnsChange,
    isLegendOutside: location === 'outside'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch",
    label: _i18n.i18n.translate('xpack.lens.shared.truncateLegend', {
      defaultMessage: 'Truncate text'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.shared.truncateLegend', {
      defaultMessage: 'Truncate text'
    }),
    "data-test-subj": "lens-legend-truncate-switch",
    showLabel: false,
    checked: shouldTruncate !== null && shouldTruncate !== void 0 ? shouldTruncate : true,
    onChange: onTruncateLegendChange
  })), shouldTruncate && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.shared.maxLinesLabel', {
      defaultMessage: 'Maximum lines'
    }),
    fullWidth: true,
    display: "columnCompressed"
  }, /*#__PURE__*/_react.default.createElement(MaxLinesInput, {
    value: maxLines !== null && maxLines !== void 0 ? maxLines : DEFAULT_TRUNCATE_LINES,
    setValue: onMaxLinesChange
  })), renderNestedLegendSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch",
    label: _i18n.i18n.translate('xpack.lens.shared.nestedLegendLabel', {
      defaultMessage: 'Nested'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.pieChart.nestedLegendLabel', {
      defaultMessage: 'Nested'
    }),
    "data-test-subj": "lens-legend-nested-switch",
    showLabel: false,
    checked: Boolean(nestedLegend),
    onChange: onNestedLegendChange
  })), renderValueInLegendSwitch && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressedSwitch",
    label: _i18n.i18n.translate('xpack.lens.shared.valueInLegendLabel', {
      defaultMessage: 'Show value'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.lens.shared.valueInLegendLabel', {
      defaultMessage: 'Show value'
    }),
    "data-test-subj": "lens-legend-show-value",
    showLabel: false,
    checked: !!valueInLegend,
    onChange: onValueInLegendChange
  }))));
};
exports.LegendSettingsPopover = LegendSettingsPopover;