"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDebounceWithOptions = void 0;
var _react = require("react");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDebounceWithOptions = (fn, {
  skipFirstRender
} = {
  skipFirstRender: false
}, ms, deps) => {
  const isFirstRender = (0, _react.useRef)(true);
  const newDeps = [...(deps || []), isFirstRender];
  return (0, _useDebounce.default)(() => {
    if (skipFirstRender && isFirstRender.current) {
      isFirstRender.current = false;
      return;
    }
    return fn();
  }, ms, newDeps);
};
exports.useDebounceWithOptions = useDebounceWithOptions;