"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TruncatedLabel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createContext = () => document.createElement('canvas').getContext('2d');

// extracted from getTextWidth for performance
const context = createContext();
const getTextWidth = (text, font) => {
  const ctx = context !== null && context !== void 0 ? context : createContext();
  ctx.font = font;
  const metrics = ctx.measureText(text);
  return metrics.width;
};
const truncateLabel = (width, font, label, approximateLength, labelFn) => {
  let output = labelFn(label, approximateLength);
  while (getTextWidth(output, font) > width) {
    approximateLength = approximateLength - 1;
    output = labelFn(label, approximateLength);
  }
  return output;
};
const TruncatedLabel = /*#__PURE__*/_react.default.memo(function TruncatedLabel({
  label,
  width,
  search,
  font
}) {
  const textWidth = (0, _react.useMemo)(() => getTextWidth(label, font), [label, font]);
  if (textWidth < width) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: search
    }, label);
  }
  const searchPosition = label.indexOf(search);
  const approximateLen = Math.round(width * label.length / textWidth);
  const separator = `…`;
  let separatorsLength = separator.length;
  let labelFn;
  if (!search || searchPosition === -1) {
    labelFn = (text, length) => `${text.substr(0, 8)}${separator}${text.substr(text.length - (length - 8))}`;
  } else if (searchPosition === 0) {
    // search phrase at the beginning
    labelFn = (text, length) => `${text.substr(0, length)}${separator}`;
  } else if (approximateLen > label.length - searchPosition) {
    // search phrase close to the end or at the end
    labelFn = (text, length) => `${separator}${text.substr(text.length - length)}`;
  } else {
    // search phrase is in the middle
    labelFn = (text, length) => `${separator}${text.substr(searchPosition, length)}${separator}`;
    separatorsLength = 2 * separator.length;
  }
  const outputLabel = truncateLabel(width, font, label, approximateLen, labelFn);
  return search.length < outputLabel.length - separatorsLength ? /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: search
  }, outputLabel) : /*#__PURE__*/_react.default.createElement(_eui.EuiMark, null, outputLabel);
});
exports.TruncatedLabel = TruncatedLabel;