"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldPicker = FieldPicker;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./field_picker.scss");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/unified-field-list-plugin/public");
var _classnames = _interopRequireDefault(require("classnames"));
var _truncated_label = require("./truncated_label");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_COMBOBOX_WIDTH = 305;
const COMBOBOX_PADDINGS = 90;
const DEFAULT_FONT = '14px Inter';
function FieldPicker({
  selectedOptions,
  options,
  onChoose,
  onDelete,
  fieldIsInvalid,
  ['data-test-subj']: dataTestSub,
  ...rest
}) {
  const styledOptions = options === null || options === void 0 ? void 0 : options.map(({
    compatible,
    exists,
    ...otherAttr
  }) => {
    if (otherAttr.options) {
      return {
        ...otherAttr,
        compatible,
        exists,
        options: otherAttr.options.map(fieldOption => ({
          ...fieldOption,
          className: (0, _classnames.default)({
            'lnFieldPicker__option--incompatible': !fieldOption.compatible,
            'lnFieldPicker__option--nonExistant': !fieldOption.exists
          })
        }))
      };
    }
    return {
      ...otherAttr,
      compatible,
      exists,
      className: (0, _classnames.default)({
        'lnFieldPicker__option--incompatible': !compatible,
        'lnFieldPicker__option--nonExistant': !exists
      })
    };
  });
  const comboBoxRef = (0, _react.useRef)(null);
  const [labelProps, setLabelProps] = _react.default.useState({
    width: DEFAULT_COMBOBOX_WIDTH - COMBOBOX_PADDINGS,
    font: DEFAULT_FONT
  });
  const computeStyles = (_e, shouldRecomputeAll = false) => {
    if (comboBoxRef.current) {
      var _comboBoxRef$current;
      const current = {
        ...labelProps,
        width: ((_comboBoxRef$current = comboBoxRef.current) === null || _comboBoxRef$current === void 0 ? void 0 : _comboBoxRef$current.clientWidth) - COMBOBOX_PADDINGS
      };
      if (shouldRecomputeAll) {
        current.font = window.getComputedStyle(comboBoxRef.current).font;
      }
      setLabelProps(current);
    }
  };
  (0, _useEffectOnce.default)(() => {
    if (comboBoxRef.current) {
      computeStyles(undefined, true);
    }
    window.addEventListener('resize', computeStyles);
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: comboBoxRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": dataTestSub !== null && dataTestSub !== void 0 ? dataTestSub : 'indexPattern-dimension-field',
    placeholder: _i18n.i18n.translate('xpack.lens.fieldPicker.fieldPlaceholder', {
      defaultMessage: 'Select a field'
    }),
    options: styledOptions,
    isInvalid: fieldIsInvalid,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    onChange: choices => {
      if (choices.length === 0) {
        onDelete === null || onDelete === void 0 ? void 0 : onDelete();
        return;
      }
      onChoose(choices[0].value);
    },
    renderOption: (option, searchValue) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: null
      }, /*#__PURE__*/_react.default.createElement(_public.FieldIcon, {
        type: option.value.dataType,
        fill: "none"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_truncated_label.TruncatedLabel, (0, _extends2.default)({}, labelProps, {
        label: option.label,
        search: searchValue
      }))));
    }
  }, rest)));
}