"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DragDropBuckets = DragDropBuckets;
exports.DraggableBucketContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _default_bucket_container = require("./default_bucket_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DraggableBucketContainer = ({
  id,
  children,
  isInsidePanel,
  Container = _default_bucket_container.DefaultBucketContainer,
  ...bucketContainerProps
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    draggableId: id,
    customDragHandle: true,
    index: bucketContainerProps.idx,
    isDragDisabled: bucketContainerProps.isNotDraggable,
    style: !isInsidePanel ? {
      marginBottom: euiTheme.size.xs
    } : {},
    spacing: "none",
    hasInteractiveChildren: true,
    disableInteractiveElementBlocking: true
  }, (provided, state) => {
    var _state$isDragging;
    return /*#__PURE__*/_react.default.createElement(Container, (0, _extends2.default)({
      draggableProvided: provided,
      isDragging: (_state$isDragging = state === null || state === void 0 ? void 0 : state.isDragging) !== null && _state$isDragging !== void 0 ? _state$isDragging : false
    }, bucketContainerProps), children);
  });
};
exports.DraggableBucketContainer = DraggableBucketContainer;
function DragDropBuckets({
  items,
  onDragStart,
  onDragEnd,
  droppableId,
  children,
  bgColor
}) {
  const [isDragging, setIsDragging] = (0, _react.useState)(false);
  const handleDragEnd = (0, _react.useCallback)(({
    source,
    destination
  }) => {
    setIsDragging(false);
    if (source && destination) {
      onDragEnd === null || onDragEnd === void 0 ? void 0 : onDragEnd((0, _eui.euiDragDropReorder)(items, source.index, destination.index));
    }
  }, [items, onDragEnd]);
  const handleDragStart = (0, _react.useCallback)(() => {
    setIsDragging(true);
    onDragStart === null || onDragStart === void 0 ? void 0 : onDragStart();
  }, [onDragStart]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDragDropContext, {
    onDragEnd: handleDragEnd,
    onDragStart: handleDragStart
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    color: isDragging ? 'success' : bgColor,
    hasShadow: false,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDroppable, {
    droppableId: droppableId,
    spacing: bgColor ? 'm' : 'none',
    style: {
      backgroundColor: 'transparent'
    }
  }, children)));
}