"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultDimensionTriggerTooltip = exports.DimensionTrigger = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDimensionTriggerTooltip = /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.configure.invalidConfigTooltip', {
  defaultMessage: 'Invalid configuration.'
}), /*#__PURE__*/_react.default.createElement("br", null), _i18n.i18n.translate('xpack.lens.configure.invalidConfigTooltipClick', {
  defaultMessage: 'Click for more details.'
}));
exports.defaultDimensionTriggerTooltip = defaultDimensionTriggerTooltip;
const DimensionTrigger = ({
  id,
  label,
  color,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    id: id,
    color: color,
    className: "lnsLayerPanel__triggerText",
    "data-test-subj": dataTestSubj || 'lns-dimensionTrigger'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "lnsLayerPanel__triggerTextLabel"
  }, label))));
};
exports.DimensionTrigger = DimensionTrigger;