"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DebouncedInput = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _debounced_value = require("./debounced_value");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DebouncedInputHelper = ({
  onChange,
  value,
  defaultValue,
  allowFalsyValue,
  ...rest
}) => {
  const {
    inputValue,
    handleInputChange,
    initialValue
  } = (0, _debounced_value.useDebouncedValue)({
    onChange,
    value,
    defaultValue
  }, {
    allowFalsyValue
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, rest, {
    value: inputValue,
    onChange: e => {
      handleInputChange(e.target.value);
    },
    placeholder: initialValue
  }));
};

/**
 * When testing this component, mock the "debounce" function in lodash (see this module test for an example)
 */
const DebouncedInput = props =>
/*#__PURE__*/
// need this extra layer to force a rerender whenever the default value changes.
// this is because we need a new initialValue to be computed from the debounce hook.
_react.default.createElement(DebouncedInputHelper, (0, _extends2.default)({}, props, {
  key: props.defaultValue
}));
exports.DebouncedInput = DebouncedInput;