"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findObjectByTitle = findObjectByTitle;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** Returns an object matching a given title */
async function findObjectByTitle(savedObjectsClient, type, title) {
  if (!title) {
    return;
  }

  // Elastic search will return the most relevant results first, which means exact matches should come
  // first, and so we shouldn't need to request everything. Using 10 just to be on the safe side.
  const response = await savedObjectsClient.find({
    type,
    perPage: 10,
    search: `"${title}"`,
    searchFields: ['title'],
    fields: ['title']
  });
  return response.savedObjects.find(obj => obj.get('title').toLowerCase() === title.toLowerCase());
}