"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorBoundary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @internal **/
const RecallError = ({
  error
}) => {
  throw error;
};
class ErrorBoundary extends _react.default.Component {
  constructor(props) {
    super(props);
  }
  static getDerivedStateFromError(error) {
    // Update state so the next render will show the fallback UI.
    return {
      originalError: error
    };
  }
  componentDidCatch(error) {
    var _this$props$onError, _this$props;
    (_this$props$onError = (_this$props = this.props).onError) === null || _this$props$onError === void 0 ? void 0 : _this$props$onError.call(_this$props, error);
  }
  componentWillReceiveProps() {
    this.setState({
      originalError: undefined
    });
  }
  render() {
    var _this$state;
    return (_this$state = this.state) !== null && _this$state !== void 0 && _this$state.originalError ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(RecallError, {
      error: this.state.originalError
    })) : this.props.children;
  }
}
exports.ErrorBoundary = ErrorBoundary;