"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AUTO_APPLY_DISABLED_STORAGE_KEY = void 0;
exports.WorkspacePanelWrapper = WorkspacePanelWrapper;
require("./workspace_panel_wrapper.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../../utils");
var _native_renderer = require("../../../native_renderer");
var _chart_switch = require("./chart_switch");
var _message_list = require("./message_list");
var _state_management = require("../../../state_management");
var _title = require("./title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTO_APPLY_DISABLED_STORAGE_KEY = 'autoApplyDisabled';
exports.AUTO_APPLY_DISABLED_STORAGE_KEY = AUTO_APPLY_DISABLED_STORAGE_KEY;
function WorkspacePanelWrapper({
  children,
  framePublicAPI,
  visualizationState,
  visualizationId,
  visualizationMap,
  datasourceMap,
  isFullscreen,
  getUserMessages
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const activeVisualization = visualizationId ? visualizationMap[visualizationId] : null;
  const setVisualizationState = (0, _react.useCallback)(newState => {
    if (!activeVisualization) {
      return;
    }
    dispatchLens((0, _state_management.updateVisualizationState)({
      visualizationId: activeVisualization.id,
      newState
    }));
  }, [dispatchLens, activeVisualization]);
  const userMessages = getUserMessages('toolbar');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    direction: "column",
    offset: 0,
    minHeight: 0,
    restrictWidth: false,
    mainProps: {
      component: 'div'
    }
  }, !(isFullscreen && (autoApplyEnabled || userMessages !== null && userMessages !== void 0 && userMessages.length)) && /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    paddingSize: "none",
    color: "transparent",
    className: "hide-for-sharing"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd",
    gutterSize: "s",
    direction: "row",
    className: (0, _classnames.default)('lnsWorkspacePanelWrapper__toolbar', {
      'lnsWorkspacePanelWrapper__toolbar--fullscreen': isFullscreen
    }),
    responsive: false
  }, !isFullscreen && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chart_switch.ChartSwitch, {
    "data-test-subj": "lnsChartSwitcher",
    visualizationMap: visualizationMap,
    datasourceMap: datasourceMap,
    framePublicAPI: framePublicAPI
  })), activeVisualization && activeVisualization.renderToolbar && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: activeVisualization.renderToolbar,
    nativeProps: {
      frame: framePublicAPI,
      state: visualizationState,
      setState: setVisualizationState
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, userMessages !== null && userMessages !== void 0 && userMessages.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_message_list.MessageList, {
    messages: userMessages
  })) : null, !autoApplyEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: autoApplyEnabled || changesApplied,
    fill: true,
    className: 'lnsWorkspacePanelWrapper__applyButton ' + _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
    iconType: "checkInCircleFilled",
    onClick: () => dispatchLens((0, _state_management.applyChanges)()),
    size: "m",
    "data-test-subj": "lnsApplyChanges__toolbar",
    minWidth: "auto"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.editorFrame.applyChangesLabel",
    defaultMessage: "Apply changes"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    grow: true,
    paddingSize: "none",
    contentProps: {
      className: 'lnsWorkspacePanelWrapper__content'
    },
    className: (0, _classnames.default)('lnsWorkspacePanelWrapper stretch-for-sharing', {
      'lnsWorkspacePanelWrapper--fullscreen': isFullscreen
    }),
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_title.WorkspaceTitle, null), children));
}