"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageList = void 0;
require("./workspace_panel_wrapper.scss");
require("./message_list.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _custom_icons = require("../custom_icons");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MessageList = ({
  messages,
  customButtonStyles
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  let warningCount = 0;
  let errorCount = 0;
  messages.forEach(({
    severity
  }) => {
    if (severity === 'warning') {
      warningCount++;
    } else {
      errorCount++;
    }
  });
  const buttonLabel = errorCount > 0 && warningCount > 0 ? _i18n.i18n.translate('xpack.lens.messagesButton.label.errorsAndWarnings', {
    defaultMessage: '{errorCount} {errorCount, plural, one {error} other {errors}}, {warningCount} {warningCount, plural, one {warning} other {warnings}}',
    values: {
      errorCount,
      warningCount
    }
  }) : errorCount > 0 ? _i18n.i18n.translate('xpack.lens.messagesButton.label.errors', {
    defaultMessage: '{errorCount} {errorCount, plural, one {error} other {errors}}',
    values: {
      errorCount
    }
  }) : _i18n.i18n.translate('xpack.lens.messagesButton.label.warnings', {
    defaultMessage: '{warningCount} {warningCount, plural, one {warning} other {warnings}}',
    values: {
      warningCount
    }
  });
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: buttonLabel
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      minWidth: 0,
      color: errorCount ? 'danger' : 'warning',
      onClick: onButtonClick,
      className: "lnsWorkspaceWarning__button",
      "data-test-subj": "lens-message-list-trigger",
      title: buttonLabel,
      css: customButtonStyles
    }, errorCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _custom_icons.IconError
    }), errorCount), warningCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: _custom_icons.IconWarning,
      css: (0, _react2.css)`
                    margin-left: 4px;
                  `
    }), warningCount))),
    isOpen: isPopoverOpen,
    closePopover: closePopover
  }, /*#__PURE__*/_react.default.createElement("ul", {
    className: "lnsWorkspaceWarningList"
  }, messages.map((message, index) => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    className: "lnsWorkspaceWarningList__item",
    "data-test-subj": `lens-message-list-${message.severity}`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, message.severity === 'error' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _custom_icons.IconError,
    color: "danger"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _custom_icons.IconWarning,
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    className: "lnsWorkspaceWarningList__description"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, message.longMessage)))))));
};
exports.MessageList = MessageList;