"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaletteIndicator = PaletteIndicator;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PaletteIndicator({
  accessorConfig
}) {
  if (accessorConfig.triggerIconType !== 'colorBy' || !accessorConfig.palette) return null;
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsLayerPanel__paletteContainer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiColorPaletteDisplay, {
    className: "lnsLayerPanel__palette",
    size: "xs",
    palette: accessorConfig.palette
  }));
}