"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerPanel = LayerPanel;
require("./layer_panel.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _layer_actions = require("./layer_actions");
var _native_renderer = require("../../../native_renderer");
var _types = require("../../../types");
var _layer_settings = require("./layer_settings");
var _dimension_container = require("./dimension_container");
var _empty_dimension_button = require("./buttons/empty_dimension_button");
var _dimension_button = require("./buttons/dimension_button");
var _draggable_dimension_button = require("./buttons/draggable_dimension_button");
var _use_focus_update = require("./use_focus_update");
var _state_management = require("../../../state_management");
var _drop_targets_utils = require("./buttons/drop_targets_utils");
var _layer_actions2 = require("./layer_actions/layer_actions");
var _flyout_container = require("./flyout_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialActiveDimensionState = {
  isNew: false
};
function LayerPanel(props) {
  var _framePublicAPI$datas, _datasourceStates$dat, _layerDatasource$uniq, _activeGroup$dimensio;
  const [activeDimension, setActiveDimension] = (0, _react.useState)(initialActiveDimensionState);
  const [isPanelSettingsOpen, setPanelSettingsOpen] = (0, _react.useState)(false);
  const [hideTooltip, setHideTooltip] = (0, _react.useState)(false);
  const {
    framePublicAPI,
    layerId,
    isOnlyLayer,
    dimensionGroups,
    onRemoveLayer,
    onCloneLayer,
    registerNewLayerRef,
    layerIndex,
    activeVisualization,
    updateVisualization,
    updateDatasource,
    toggleFullscreen,
    updateAll,
    updateDatasourceAsync,
    visualizationState,
    onChangeIndexPattern,
    core
  } = props;
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const dateRange = (0, _state_management.useLensSelector)(_state_management.selectResolvedDateRange);
  (0, _react.useEffect)(() => {
    setActiveDimension(initialActiveDimensionState);
  }, [activeVisualization.id]);
  const panelRef = (0, _react.useRef)(null);
  const settingsPanelRef = (0, _react.useRef)(null);
  const registerLayerRef = (0, _react.useCallback)(el => registerNewLayerRef(layerId, el), [layerId, registerNewLayerRef]);
  const layerVisualizationConfigProps = {
    layerId,
    state: props.visualizationState,
    frame: props.framePublicAPI,
    dateRange,
    activeData: props.framePublicAPI.activeData
  };
  const datasourcePublicAPI = (_framePublicAPI$datas = framePublicAPI.datasourceLayers) === null || _framePublicAPI$datas === void 0 ? void 0 : _framePublicAPI$datas[layerId];
  const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
  const layerDatasourceState = datasourceId ? datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state : undefined;
  const layerDatasource = datasourceId ? props.datasourceMap[datasourceId] : undefined;
  const layerDatasourceConfigProps = {
    state: layerDatasourceState,
    setState: newState => {
      updateDatasource(datasourceId, newState);
    },
    layerId,
    frame: props.framePublicAPI,
    dateRange
  };
  const columnLabelMap = !layerDatasource && activeVisualization.getUniqueLabels ? activeVisualization.getUniqueLabels(props.visualizationState) : layerDatasource === null || layerDatasource === void 0 ? void 0 : (_layerDatasource$uniq = layerDatasource.uniqueLabels) === null || _layerDatasource$uniq === void 0 ? void 0 : _layerDatasource$uniq.call(layerDatasource, layerDatasourceConfigProps === null || layerDatasourceConfigProps === void 0 ? void 0 : layerDatasourceConfigProps.state);
  const isEmptyLayer = !dimensionGroups.some(d => d.accessors.length > 0);
  const {
    activeId,
    activeGroup
  } = activeDimension;
  const allAccessors = dimensionGroups.flatMap(group => group.accessors.map(accessor => accessor.columnId));
  const {
    setNextFocusedId: setNextFocusedButtonId,
    removeRef: removeButtonRef,
    registerNewRef: registerNewButtonRef
  } = (0, _use_focus_update.useFocusUpdate)(allAccessors);
  const onDrop = (0, _react.useMemo)(() => {
    return (source, target, dropType) => {
      if (!dropType) {
        return;
      }
      if (!(0, _types.isOperation)(target)) {
        throw new Error('Drop target should be an operation');
      }
      if (dropType === 'reorder' || dropType === 'field_replace' || dropType === 'field_add') {
        setNextFocusedButtonId(source.id);
      } else {
        setNextFocusedButtonId(target.columnId);
      }
      let hasDropSucceeded = true;
      if (layerDatasource) {
        var _dimensionGroups$find;
        hasDropSucceeded = Boolean(layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.onDrop({
          state: layerDatasourceState,
          setState: newState => {
            // we don't sync linked dimension here because that would trigger an onDrop routine within an onDrop routine
            updateDatasource(datasourceId, newState, true);
          },
          source,
          target: {
            ...target,
            filterOperations: ((_dimensionGroups$find = dimensionGroups.find(({
              groupId: gId
            }) => gId === target.groupId)) === null || _dimensionGroups$find === void 0 ? void 0 : _dimensionGroups$find.filterOperations) || Boolean
          },
          targetLayerDimensionGroups: dimensionGroups,
          dropType,
          indexPatterns: framePublicAPI.dataViews.indexPatterns
        }));
      }
      if (hasDropSucceeded) {
        var _activeVisualization$, _ref;
        activeVisualization.onDrop = (_activeVisualization$ = activeVisualization.onDrop) === null || _activeVisualization$ === void 0 ? void 0 : _activeVisualization$.bind(activeVisualization);
        updateVisualization((_ref = activeVisualization.onDrop || _drop_targets_utils.onDropForVisualization) === null || _ref === void 0 ? void 0 : _ref({
          prevState: props.visualizationState,
          frame: framePublicAPI,
          target,
          source,
          dropType,
          group: dimensionGroups.find(({
            groupId: gId
          }) => gId === target.groupId)
        }, activeVisualization));
        if ((0, _types.isOperation)(source) && (0, _drop_targets_utils.shouldRemoveSource)(source, dropType)) {
          props.onRemoveDimension({
            columnId: source.columnId,
            layerId: source.layerId
          });
        }
      }
    };
  }, [layerDatasource, setNextFocusedButtonId, layerDatasourceState, dimensionGroups, framePublicAPI, updateDatasource, datasourceId, activeVisualization, updateVisualization, props]);
  const isDimensionPanelOpen = Boolean(activeId);
  const updateDataLayerState = (0, _react.useCallback)((newState, {
    isDimensionComplete = true,
    // this flag is a hack to force a sync render where it was planned an async/setTimeout state update
    // TODO: revisit this once we get rid of updateDatasourceAsync upstream
    forceRender = false
  } = {}) => {
    if (!activeGroup || !activeId) {
      return;
    }
    if (allAccessors.includes(activeId)) {
      if (isDimensionComplete) {
        if (forceRender) {
          updateDatasource(datasourceId, newState);
        } else {
          updateDatasourceAsync(datasourceId, newState);
        }
      } else {
        // The datasource can indicate that the previously-valid column is no longer
        // complete, which clears the visualization. This keeps the flyout open and reuses
        // the previous columnId
        props.updateDatasource(datasourceId, newState);
        props.onRemoveDimension({
          layerId,
          columnId: activeId
        });
      }
    } else if (isDimensionComplete) {
      updateAll(datasourceId, newState, activeVisualization.setDimension({
        layerId,
        groupId: activeGroup.groupId,
        columnId: activeId,
        prevState: visualizationState,
        frame: framePublicAPI
      }));
      setActiveDimension({
        ...activeDimension,
        isNew: false
      });
    } else {
      if (forceRender) {
        updateDatasource(datasourceId, newState);
      } else {
        updateDatasourceAsync(datasourceId, newState);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [activeDimension, activeGroup, activeId, activeVisualization, datasourceId, layerId, updateAll, updateDatasourceAsync, visualizationState, framePublicAPI]);
  const {
    dataViews
  } = props.framePublicAPI;
  const [datasource] = Object.values(framePublicAPI.datasourceLayers);
  const isTextBasedLanguage = Boolean(datasource === null || datasource === void 0 ? void 0 : datasource.isTextBasedLanguage());
  const visualizationLayerSettings = (0, _react.useMemo)(() => {
    var _activeVisualization$2;
    return ((_activeVisualization$2 = activeVisualization.hasLayerSettings) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, {
      layerId,
      state: visualizationState,
      frame: props.framePublicAPI
    })) || {
      data: false,
      appearance: false
    };
  }, [activeVisualization, layerId, props.framePublicAPI, visualizationState]);
  const compatibleActions = (0, _react.useMemo)(() => {
    var _activeVisualization$3;
    return [...(((_activeVisualization$3 = activeVisualization.getSupportedActionsForLayer) === null || _activeVisualization$3 === void 0 ? void 0 : _activeVisualization$3.call(activeVisualization, layerId, visualizationState).map(action => ({
      ...action,
      execute: () => {
        var _activeVisualization$4;
        updateVisualization((_activeVisualization$4 = activeVisualization.onLayerAction) === null || _activeVisualization$4 === void 0 ? void 0 : _activeVisualization$4.call(activeVisualization, layerId, action.id, visualizationState));
      }
    }))) || []), ...(0, _layer_actions2.getSharedActions)({
      layerId,
      activeVisualization,
      visualizationState,
      core,
      layerIndex,
      layerType: activeVisualization.getLayerType(layerId, visualizationState),
      isOnlyLayer,
      isTextBasedLanguage,
      hasLayerSettings: Boolean(Object.values(visualizationLayerSettings).some(Boolean) && activeVisualization.renderLayerSettings || (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.renderLayerSettings)),
      openLayerSettings: () => setPanelSettingsOpen(true),
      onCloneLayer,
      onRemoveLayer: () => onRemoveLayer(layerId)
    })].filter(i => i.isCompatible);
  }, [activeVisualization, core, isOnlyLayer, isTextBasedLanguage, layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.renderLayerSettings, layerId, layerIndex, onCloneLayer, onRemoveLayer, updateVisualization, visualizationLayerSettings, visualizationState]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("section", {
    tabIndex: -1,
    ref: registerLayerRef,
    className: "lnsLayerPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `lns-layerPanel-${layerIndex}`,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement("header", {
    className: "lnsLayerPanel__layerHeader"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: "lnsLayerPanel__layerSettingsWrapper"
  }, /*#__PURE__*/_react.default.createElement(_layer_settings.LayerSettings, {
    layerConfigProps: {
      ...layerVisualizationConfigProps,
      setState: props.updateVisualization,
      onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
        indexPatternId,
        layerId,
        visualizationId: activeVisualization.id
      })
    },
    activeVisualization: activeVisualization
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_layer_actions.LayerActions, {
    actions: compatibleActions,
    layerIndex: layerIndex
  }))), (layerDatasource || activeVisualization.renderLayerPanel) && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), layerDatasource && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: layerDatasource.renderLayerPanel,
    nativeProps: {
      layerId,
      state: layerDatasourceState,
      activeData: props.framePublicAPI.activeData,
      dataViews,
      onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
        indexPatternId,
        layerId,
        datasourceId
      })
    }
  }), activeVisualization.renderLayerPanel && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: activeVisualization.renderLayerPanel,
    nativeProps: {
      layerId,
      state: visualizationState,
      frame: framePublicAPI,
      setState: props.updateVisualization,
      onChangeIndexPattern: indexPatternId => onChangeIndexPattern({
        indexPatternId,
        layerId,
        visualizationId: activeVisualization.id
      })
    }
  })), dimensionGroups.map((group, groupIndex) => {
    var _activeVisualization$7;
    let errorText = '';
    if (!isEmptyLayer) {
      if (group.requiredMinDimensionCount && group.requiredMinDimensionCount > group.accessors.length) {
        if (group.requiredMinDimensionCount > 1) {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresTwoOrMoreFieldsWarningLabel', {
            defaultMessage: 'Requires {requiredMinDimensionCount} fields',
            values: {
              requiredMinDimensionCount: group.requiredMinDimensionCount
            }
          });
        } else {
          errorText = _i18n.i18n.translate('xpack.lens.editorFrame.requiresFieldWarningLabel', {
            defaultMessage: 'Requires field'
          });
        }
      } else if (group.dimensionsTooMany && group.dimensionsTooMany > 0) {
        errorText = _i18n.i18n.translate('xpack.lens.editorFrame.tooManyDimensionsSingularWarningLabel', {
          defaultMessage: 'Please remove {dimensionsTooMany, plural, one {a dimension} other {{dimensionsTooMany} dimensions}}',
          values: {
            dimensionsTooMany: group.dimensionsTooMany
          }
        });
      }
    }
    const isOptional = !group.requiredMinDimensionCount && !group.suggestedValue;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "lnsLayerPanel__row",
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.groupLabel, group.groupTooltip && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        color: "subdued",
        content: group.groupTooltip,
        iconProps: {
          className: 'eui-alignTop'
        },
        position: "top",
        size: "s",
        type: "questionInCircle"
      }))),
      labelAppend: isOptional ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        "data-test-subj": "lnsGroup_optional"
      }, _i18n.i18n.translate('xpack.lens.editorFrame.optionalDimensionLabel', {
        defaultMessage: 'Optional'
      })) : null,
      labelType: "legend",
      key: group.groupId,
      isInvalid: Boolean(errorText),
      error: errorText
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, group.accessors.length ? /*#__PURE__*/_react.default.createElement(_domDragDrop.ReorderProvider, {
      id: group.groupId,
      className: 'lnsLayerPanel__group',
      dataTestSubj: "lnsDragDrop"
    }, group.accessors.map((accessorConfig, accessorIndex) => {
      var _activeVisualization$5, _columnLabelMap$colum, _columnLabelMap$acces, _activeVisualization$6, _columnLabelMap$colum2;
      const {
        columnId
      } = accessorConfig;
      const messages = props.getUserMessages('dimensionButton', {
        dimensionId: columnId
      });
      return /*#__PURE__*/_react.default.createElement(_draggable_dimension_button.DraggableDimensionButton, {
        activeVisualization: activeVisualization,
        registerNewButtonRef: registerNewButtonRef,
        order: [2, layerIndex, groupIndex, accessorIndex],
        target: {
          id: columnId,
          layerId,
          columnId,
          groupId: group.groupId,
          filterOperations: group.filterOperations,
          prioritizedOperation: group.prioritizedOperation,
          indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$5 = activeVisualization.getUsedDataView) === null || _activeVisualization$5 === void 0 ? void 0 : _activeVisualization$5.call(activeVisualization, visualizationState, layerId),
          humanData: {
            label: (_columnLabelMap$colum = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum !== void 0 ? _columnLabelMap$colum : '',
            groupLabel: group.groupLabel,
            position: accessorIndex + 1,
            layerNumber: layerIndex + 1
          }
        },
        group: group,
        key: columnId,
        state: layerDatasourceState,
        layerDatasource: layerDatasource,
        datasourceLayers: framePublicAPI.datasourceLayers,
        onDragStart: () => setHideTooltip(true),
        onDragEnd: () => setHideTooltip(false),
        onDrop: onDrop,
        indexPatterns: dataViews.indexPatterns
      }, /*#__PURE__*/_react.default.createElement(_dimension_button.DimensionButton, {
        className: "lnsLayerPanel__dimension",
        accessorConfig: accessorConfig,
        label: (_columnLabelMap$acces = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[accessorConfig.columnId]) !== null && _columnLabelMap$acces !== void 0 ? _columnLabelMap$acces : '',
        group: group,
        onClick: id => {
          setActiveDimension({
            isNew: false,
            activeGroup: group,
            activeId: id
          });
        },
        onRemoveClick: id => {
          props.onRemoveDimension({
            columnId: id,
            layerId
          });
          removeButtonRef(id);
        },
        message: messages[0]
      }, layerDatasource ? /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
        render: layerDatasource.renderDimensionTrigger,
        nativeProps: {
          ...layerDatasourceConfigProps,
          columnId: accessorConfig.columnId,
          groupId: group.groupId,
          filterOperations: group.filterOperations,
          indexPatterns: dataViews.indexPatterns
        }
      }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeVisualization === null || activeVisualization === void 0 ? void 0 : (_activeVisualization$6 = activeVisualization.renderDimensionTrigger) === null || _activeVisualization$6 === void 0 ? void 0 : _activeVisualization$6.call(activeVisualization, {
        columnId,
        label: (_columnLabelMap$colum2 = columnLabelMap === null || columnLabelMap === void 0 ? void 0 : columnLabelMap[columnId]) !== null && _columnLabelMap$colum2 !== void 0 ? _columnLabelMap$colum2 : '',
        hideTooltip
      }))));
    })) : null, group.fakeFinalAccessor && /*#__PURE__*/_react.default.createElement("div", {
      className: "lnsLayerPanel__dimension domDragDrop-isDraggable",
      css: (0, _react2.css)`
                        cursor: default !important;
                        border-color: transparent !important;
                        margin-top: ${group.accessors.length ? 8 : 0}px !important;
                        background-color: ${_uiTheme.euiThemeVars.euiColorLightShade} !important;
                        box-shadow: none !important;
                      `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "lnsLayerPanel__triggerText",
      "data-test-subj": "lns-fakeDimension",
      color: 'subdued'
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "lnsLayerPanel__triggerTextLabel"
    }, group.fakeFinalAccessor.label))), group.supportsMoreColumns ? /*#__PURE__*/_react.default.createElement(_empty_dimension_button.EmptyDimensionButton, {
      activeVisualization: activeVisualization,
      order: [2, layerIndex, groupIndex, group.accessors.length],
      group: group,
      target: {
        layerId,
        groupId: group.groupId,
        filterOperations: group.filterOperations,
        prioritizedOperation: group.prioritizedOperation,
        isNewColumn: true,
        isMetricDimension: group === null || group === void 0 ? void 0 : group.isMetricDimension,
        indexPatternId: layerDatasource ? layerDatasource.getUsedDataView(layerDatasourceState, layerId) : (_activeVisualization$7 = activeVisualization.getUsedDataView) === null || _activeVisualization$7 === void 0 ? void 0 : _activeVisualization$7.call(activeVisualization, visualizationState, layerId),
        humanData: {
          groupLabel: group.groupLabel,
          layerNumber: layerIndex + 1,
          position: group.accessors.length + 1,
          label: _i18n.i18n.translate('xpack.lens.indexPattern.emptyDimensionButton', {
            defaultMessage: 'Empty dimension'
          })
        }
      },
      layerDatasource: layerDatasource,
      state: layerDatasourceState,
      datasourceLayers: framePublicAPI.datasourceLayers,
      onClick: id => {
        props.onEmptyDimensionAdd(id, group);
        setActiveDimension({
          activeGroup: group,
          activeId: id,
          isNew: !group.supportStaticValue && Boolean(layerDatasource)
        });
      },
      onDrop: onDrop,
      indexPatterns: dataViews.indexPatterns
    }) : null));
  }))), ((layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.renderLayerSettings) || (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.renderLayerSettings)) && /*#__PURE__*/_react.default.createElement(_flyout_container.FlyoutContainer, {
    panelRef: el => settingsPanelRef.current = el,
    isOpen: isPanelSettingsOpen,
    isFullscreen: false,
    groupLabel: _i18n.i18n.translate('xpack.lens.editorFrame.layerSettingsTitle', {
      defaultMessage: 'Layer settings'
    }),
    handleClose: () => {
      // update the current layer settings
      setPanelSettingsOpen(false);
      return true;
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: layerId
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsIndexPatternDimensionEditor--padded"
  }, layerDatasource !== null && layerDatasource !== void 0 && layerDatasource.renderLayerSettings || visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
                  `
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingData', {
    defaultMessage: 'Data'
  }))) : null, (layerDatasource === null || layerDatasource === void 0 ? void 0 : layerDatasource.renderLayerSettings) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: layerDatasource.renderLayerSettings,
    nativeProps: layerDatasourceConfigProps
  })), layerDatasource !== null && layerDatasource !== void 0 && layerDatasource.renderLayerSettings && visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }) : null, activeVisualization !== null && activeVisualization !== void 0 && activeVisualization.renderLayerSettings && visualizationLayerSettings.data ? /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.renderLayerSettings,
    nativeProps: {
      ...layerVisualizationConfigProps,
      setState: props.updateVisualization,
      panelRef: settingsPanelRef,
      section: 'data'
    }
  }) : null, visualizationLayerSettings.appearance ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
                  `
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.lens.editorFrame.layerSettings.headingAppearance', {
    defaultMessage: 'Appearance'
  }))) : null, (activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.renderLayerSettings) && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
    render: activeVisualization === null || activeVisualization === void 0 ? void 0 : activeVisualization.renderLayerSettings,
    nativeProps: {
      ...layerVisualizationConfigProps,
      setState: props.updateVisualization,
      panelRef: settingsPanelRef,
      section: 'appearance'
    }
  })))), /*#__PURE__*/_react.default.createElement(_dimension_container.DimensionContainer, {
    panelRef: el => panelRef.current = el,
    isOpen: isDimensionPanelOpen,
    isFullscreen: isFullscreen,
    groupLabel: (_activeGroup$dimensio = activeGroup === null || activeGroup === void 0 ? void 0 : activeGroup.dimensionEditorGroupLabel) !== null && _activeGroup$dimensio !== void 0 ? _activeGroup$dimensio : (activeGroup === null || activeGroup === void 0 ? void 0 : activeGroup.groupLabel) || '',
    handleClose: () => {
      if (layerDatasource) {
        if (layerDatasource.canCloseDimensionEditor && !layerDatasource.canCloseDimensionEditor(layerDatasourceState)) {
          return false;
        }
        if (layerDatasource.updateStateOnCloseDimension) {
          const newState = layerDatasource.updateStateOnCloseDimension({
            state: layerDatasourceState,
            layerId,
            columnId: activeId
          });
          if (newState) {
            props.updateDatasource(datasourceId, newState);
          }
        }
      }
      setActiveDimension(initialActiveDimensionState);
      if (isFullscreen) {
        toggleFullscreen();
      }
      return true;
    },
    panel: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, activeGroup && activeId && layerDatasource && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
      render: layerDatasource.renderDimensionEditor,
      nativeProps: {
        ...layerDatasourceConfigProps,
        core: props.core,
        columnId: activeId,
        groupId: activeGroup.groupId,
        hideGrouping: activeGroup.hideGrouping,
        filterOperations: activeGroup.filterOperations,
        isMetricDimension: activeGroup === null || activeGroup === void 0 ? void 0 : activeGroup.isMetricDimension,
        dimensionGroups,
        toggleFullscreen,
        isFullscreen,
        setState: updateDataLayerState,
        supportStaticValue: Boolean(activeGroup.supportStaticValue),
        paramEditorCustomProps: activeGroup.paramEditorCustomProps,
        enableFormatSelector: activeGroup.enableFormatSelector !== false,
        formatSelectorOptions: activeGroup.formatSelectorOptions,
        layerType: activeVisualization.getLayerType(layerId, visualizationState),
        indexPatterns: dataViews.indexPatterns,
        activeData: layerVisualizationConfigProps.activeData,
        dataSectionExtra: !isFullscreen && !activeDimension.isNew && activeVisualization.renderDimensionEditorDataExtra && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
          render: activeVisualization.renderDimensionEditorDataExtra,
          nativeProps: {
            ...layerVisualizationConfigProps,
            groupId: activeGroup.groupId,
            accessor: activeId,
            datasource,
            setState: props.updateVisualization,
            addLayer: props.addLayer,
            removeLayer: props.onRemoveLayer,
            panelRef
          }
        })
      }
    }), activeGroup && activeId && !isFullscreen && !activeDimension.isNew && activeVisualization.renderDimensionEditor && (activeGroup === null || activeGroup === void 0 ? void 0 : activeGroup.enableDimensionEditor) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "lnsLayerPanel__styleEditor"
    }, /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
      render: activeVisualization.renderDimensionEditor,
      nativeProps: {
        ...layerVisualizationConfigProps,
        groupId: activeGroup.groupId,
        accessor: activeId,
        datasource,
        setState: props.updateVisualization,
        addLayer: props.addLayer,
        removeLayer: props.onRemoveLayer,
        panelRef
      }
    })), activeVisualization.renderDimensionEditorAdditionalSection && /*#__PURE__*/_react.default.createElement(_native_renderer.NativeRenderer, {
      render: activeVisualization.renderDimensionEditorAdditionalSection,
      nativeProps: {
        ...layerVisualizationConfigProps,
        groupId: activeGroup.groupId,
        accessor: activeId,
        datasource,
        setState: props.updateVisualization,
        addLayer: props.addLayer,
        removeLayer: props.onRemoveLayer,
        panelRef
      }
    })))
  }));
}