"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRemoveLayerAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _public3 = require("@kbn/expression-xy-plugin/public");
var _settings_storage = require("../../../../settings_storage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SKIP_DELETE_MODAL_KEY = 'skipDeleteModal';
const getCopy = (layerType, isOnlyLayer) => {
  if (isOnlyLayer && layerType === 'data') {
    return {
      buttonLabel: _i18n.i18n.translate('xpack.lens.resetLayerAriaLabel', {
        defaultMessage: 'Clear layer'
      }),
      modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.title.clearVis', {
        defaultMessage: 'Clear visualization layer?'
      }),
      modalBody: _i18n.i18n.translate('xpack.lens.layer.confirmModal.clearVis', {
        defaultMessage: `Clearing this layer removes the visualization and its configurations. `
      })
    };
  }
  const buttonLabel = _i18n.i18n.translate('xpack.lens.deleteLayerAriaLabel', {
    defaultMessage: `Delete layer`
  });
  switch (layerType) {
    case 'data':
      return {
        buttonLabel,
        modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteVis', {
          defaultMessage: 'Delete visualization layer?'
        }),
        modalBody: _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteVis', {
          defaultMessage: `Deleting this layer removes the visualization and its configurations. `
        })
      };
    case 'annotations':
      return {
        buttonLabel,
        modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteAnnotations', {
          defaultMessage: 'Delete annotations layer?'
        }),
        modalBody: _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteAnnotation', {
          defaultMessage: `Deleting this layer removes the annotations and their configurations. `
        })
      };
    case 'referenceLine':
      return {
        buttonLabel,
        modalTitle: _i18n.i18n.translate('xpack.lens.modalTitle.title.deleteReferenceLines', {
          defaultMessage: 'Delete reference lines layer?'
        }),
        modalBody: _i18n.i18n.translate('xpack.lens.layer.confirmModal.deleteRefLine', {
          defaultMessage: `Deleting this layer removes the reference lines and their configurations. `
        })
      };
    default:
      throw new Error('Unknown layer type');
  }
};
const RemoveConfirmModal = ({
  modalTitle,
  modalDesc,
  skipDeleteModal,
  isDeletable,
  execute,
  closeModal,
  updateLensLocalStorage
}) => {
  const [skipDeleteModalLocal, setSkipDeleteModalLocal] = (0, _react.useState)(skipDeleteModal);
  const onChangeShouldShowModal = (0, _react.useCallback)(({
    target
  }) => setSkipDeleteModalLocal(target.checked), []);
  const onRemove = (0, _react.useCallback)(() => {
    updateLensLocalStorage({
      [SKIP_DELETE_MODAL_KEY]: skipDeleteModalLocal
    });
    closeModal();
    execute();
  }, [closeModal, execute, skipDeleteModalLocal, updateLensLocalStorage]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, modalTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement("p", null, modalDesc, _i18n.i18n.translate('xpack.lens.layer.confirmModal.cannotUndo', {
    defaultMessage: `You can't undo this action.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: 'lnsLayerRemoveModalCheckbox',
    label: _i18n.i18n.translate('xpack.lens.layer.confirmModal.dontAskAgain', {
      defaultMessage: `Don't ask me again`
    }),
    checked: skipDeleteModalLocal,
    onChange: onChangeShouldShowModal
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, _i18n.i18n.translate('xpack.lens.layer.cancelDelete', {
    defaultMessage: `Cancel`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "lnsLayerRemoveConfirmButton",
    onClick: onRemove,
    color: "danger",
    iconType: isDeletable ? 'trash' : 'eraser',
    fill: true
  }, isDeletable ? _i18n.i18n.translate('xpack.lens.layer.confirmDelete', {
    defaultMessage: `Delete layer`
  }) : _i18n.i18n.translate('xpack.lens.layer.confirmClear', {
    defaultMessage: `Clear layer`
  }))))))));
};
const getRemoveLayerAction = props => {
  const {
    buttonLabel,
    modalTitle,
    modalBody
  } = getCopy(props.layerType || _public3.LayerTypes.DATA, props.isOnlyLayer);
  return {
    id: 'removeLayerAction',
    execute: async () => {
      var _storage$get;
      const storage = new _public2.Storage(localStorage);
      const lensLocalStorage = (_storage$get = storage.get(_settings_storage.LOCAL_STORAGE_LENS_KEY)) !== null && _storage$get !== void 0 ? _storage$get : {};
      const updateLensLocalStorage = partial => {
        storage.set(_settings_storage.LOCAL_STORAGE_LENS_KEY, {
          ...lensLocalStorage,
          ...partial
        });
      };
      if (!lensLocalStorage.skipDeleteModal) {
        var _lensLocalStorage$LOC;
        const modal = props.core.overlays.openModal((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(RemoveConfirmModal, {
          modalTitle: modalTitle,
          isDeletable: !props.isOnlyLayer,
          modalDesc: modalBody,
          skipDeleteModal: (_lensLocalStorage$LOC = lensLocalStorage[_settings_storage.LOCAL_STORAGE_LENS_KEY]) !== null && _lensLocalStorage$LOC !== void 0 ? _lensLocalStorage$LOC : false,
          execute: props.execute,
          closeModal: () => modal.close(),
          updateLensLocalStorage: updateLensLocalStorage
        }), {
          theme$: props.core.theme.theme$
        }), {
          'data-test-subj': 'lnsLayerRemoveModal'
        });
        await modal.onClose;
      } else {
        props.execute();
      }
    },
    displayName: buttonLabel,
    isCompatible: true,
    icon: props.isOnlyLayer ? 'eraser' : 'trash',
    color: 'danger',
    'data-test-subj': `lnsLayerRemove--${props.layerIndex}`
  };
};
exports.getRemoveLayerAction = getRemoveLayerAction;