"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionButtonIcon = DimensionButtonIcon;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _custom_icons = require("../custom_icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseIconProps = {
  className: 'lnsLayerPanel__colorIndicator'
};
const getIconFromAccessorConfig = accessorConfig => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accessorConfig.triggerIconType === 'color' && accessorConfig.color && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  color: accessorConfig.color,
  type: "stopFilled",
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.colorIndicatorLabel', {
    defaultMessage: 'Color of this dimension: {hex}',
    values: {
      hex: accessorConfig.color
    }
  })
})), accessorConfig.triggerIconType === 'disabled' && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  type: "stopSlash",
  color: "subdued",
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.noColorIndicatorLabel', {
    defaultMessage: 'This dimension does not have an individual color'
  })
})), accessorConfig.triggerIconType === 'invisible' && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  type: "eyeClosed",
  color: "subdued",
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.invisibleIndicatorLabel', {
    defaultMessage: 'This dimension is currently not visible in the chart'
  })
})), accessorConfig.triggerIconType === 'aggregate' && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  type: "fold",
  color: "subdued",
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.aggregateIndicatorLabel', {
    defaultMessage: 'This dimension is not visible in the chart because all individual values are aggregated into a single value'
  })
})), accessorConfig.triggerIconType === 'colorBy' && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  type: "color",
  color: "subdued",
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.paletteColorIndicatorLabel', {
    defaultMessage: 'This dimension is using a palette'
  })
})), accessorConfig.triggerIconType === 'custom' && accessorConfig.customIcon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
  type: accessorConfig.customIcon,
  color: accessorConfig.color,
  "aria-label": _i18n.i18n.translate('xpack.lens.editorFrame.customIconIndicatorLabel', {
    defaultMessage: 'This dimension is using a custom icon'
  })
})));
function DimensionButtonIcon({
  accessorConfig,
  message,
  children
}) {
  let indicatorIcon = null;
  if (message || accessorConfig.triggerIconType !== 'none') {
    indicatorIcon = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, accessorConfig.triggerIconType !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, getIconFromAccessorConfig(accessorConfig)), message && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, baseIconProps, {
      type: message.severity === 'error' ? _custom_icons.IconError : _custom_icons.IconWarning
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    responsive: false
  }, indicatorIcon, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children));
}