"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigPanelWrapper = void 0;
exports.LayerPanels = LayerPanels;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _esQuery = require("@kbn/es-query");
var _public = require("@kbn/unified-search-plugin/public");
var _lens_slice = require("../../../state_management/lens_slice");
var _layer_panel = require("./layer_panel");
var _id_generator = require("../../../id_generator");
var _use_focus_update = require("./use_focus_update");
var _state_management = require("../../../state_management");
var _add_layer = require("./add_layer");
var _utils = require("../../../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigPanelWrapper = /*#__PURE__*/(0, _react.memo)(function ConfigPanelWrapper(props) {
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const activeVisualization = visualization.activeId ? props.visualizationMap[visualization.activeId] : null;
  return activeVisualization && visualization.state ? /*#__PURE__*/_react.default.createElement(LayerPanels, (0, _extends2.default)({}, props, {
    activeVisualization: activeVisualization
  })) : null;
});
exports.ConfigPanelWrapper = ConfigPanelWrapper;
function LayerPanels(props) {
  const {
    activeVisualization,
    datasourceMap,
    indexPatternService
  } = props;
  const {
    activeDatasourceId,
    visualization,
    datasourceStates,
    query
  } = (0, _state_management.useLensSelector)(state => state.lens);
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const layerIds = activeVisualization.getLayerIds(visualization.state);
  const {
    setNextFocusedId: setNextFocusedLayerId,
    removeRef: removeLayerRef,
    registerNewRef: registerNewLayerRef
  } = (0, _use_focus_update.useFocusUpdate)(layerIds);
  const setVisualizationState = (0, _react.useMemo)(() => newState => {
    dispatchLens((0, _state_management.updateVisualizationState)({
      visualizationId: activeVisualization.id,
      newState
    }));
  }, [activeVisualization, dispatchLens]);
  const updateDatasource = (0, _react.useMemo)(() => (datasourceId, newState, dontSyncLinkedDimensions) => {
    if (datasourceId) {
      dispatchLens((0, _state_management.updateDatasourceState)({
        updater: prevState => typeof newState === 'function' ? newState(prevState) : newState,
        datasourceId,
        clearStagedPreview: false,
        dontSyncLinkedDimensions
      }));
    }
  }, [dispatchLens]);
  const updateDatasourceAsync = (0, _react.useMemo)(() => (datasourceId, newState) => {
    // React will synchronously update if this is triggered from a third party component,
    // which we don't want. The timeout lets user interaction have priority, then React updates.
    setTimeout(() => {
      updateDatasource(datasourceId, newState);
    }, 0);
  }, [updateDatasource]);
  const updateAll = (0, _react.useMemo)(() => (datasourceId, newDatasourceState, newVisualizationState) => {
    if (!datasourceId) return;
    // React will synchronously update if this is triggered from a third party component,
    // which we don't want. The timeout lets user interaction have priority, then React updates.

    setTimeout(() => {
      dispatchLens((0, _state_management.updateState)({
        updater: prevState => {
          const updatedDatasourceState = typeof newDatasourceState === 'function' ? newDatasourceState(prevState.datasourceStates[datasourceId].state) : newDatasourceState;
          const updatedVisualizationState = typeof newVisualizationState === 'function' ? newVisualizationState(prevState.visualization.state) : newVisualizationState;
          return {
            ...prevState,
            datasourceStates: {
              ...prevState.datasourceStates,
              [datasourceId]: {
                state: updatedDatasourceState,
                isLoading: false
              }
            },
            visualization: {
              ...prevState.visualization,
              state: updatedVisualizationState
            }
          };
        }
      }));
    }, 0);
  }, [dispatchLens]);
  const toggleFullscreen = (0, _react.useMemo)(() => () => {
    dispatchLens((0, _state_management.setToggleFullscreen)());
  }, [dispatchLens]);
  const onRemoveLayer = (0, _react.useCallback)(layerToRemoveId => {
    var _props$framePublicAPI;
    const datasourcePublicAPI = (_props$framePublicAPI = props.framePublicAPI.datasourceLayers) === null || _props$framePublicAPI === void 0 ? void 0 : _props$framePublicAPI[layerToRemoveId];
    const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
    if (datasourceId) {
      var _datasourceStates$dat;
      const layerDatasource = datasourceMap[datasourceId];
      const layerDatasourceState = datasourceStates === null || datasourceStates === void 0 ? void 0 : (_datasourceStates$dat = datasourceStates[datasourceId]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state;
      const trigger = props.uiActions.getTrigger(_public.UPDATE_FILTER_REFERENCES_TRIGGER);
      const action = props.uiActions.getAction(_public.UPDATE_FILTER_REFERENCES_ACTION);
      action === null || action === void 0 ? void 0 : action.execute({
        trigger,
        fromDataView: layerDatasource.getUsedDataView(layerDatasourceState, layerToRemoveId),
        usedDataViews: layerDatasource.getLayers(layerDatasourceState).map(layer => layerDatasource.getUsedDataView(layerDatasourceState, layer)),
        defaultDataView: layerDatasource.getUsedDataView(layerDatasourceState)
      });
    }
    dispatchLens((0, _state_management.removeOrClearLayer)({
      visualizationId: activeVisualization.id,
      layerId: layerToRemoveId,
      layerIds
    }));
    removeLayerRef(layerToRemoveId);
  }, [activeVisualization.id, datasourceMap, datasourceStates, dispatchLens, layerIds, props.framePublicAPI.datasourceLayers, props.uiActions, removeLayerRef]);
  const onChangeIndexPattern = (0, _react.useCallback)(async ({
    indexPatternId,
    datasourceId,
    visualizationId,
    layerId
  }) => {
    const indexPatterns = await props.indexPatternService.ensureIndexPattern({
      id: indexPatternId,
      cache: props.framePublicAPI.dataViews.indexPatterns
    });
    dispatchLens((0, _lens_slice.changeIndexPattern)({
      indexPatternId,
      datasourceIds: datasourceId ? [datasourceId] : [],
      visualizationIds: visualizationId ? [visualizationId] : [],
      layerId,
      dataViews: {
        indexPatterns
      }
    }));
  }, [dispatchLens, props.framePublicAPI.dataViews.indexPatterns, props.indexPatternService]);
  const addLayer = layerType => {
    const layerId = (0, _id_generator.generateId)();
    dispatchLens((0, _state_management.addLayer)({
      layerId,
      layerType
    }));
    setNextFocusedLayerId(layerId);
  };
  const hideAddLayerButton = query && (0, _esQuery.isOfAggregateQueryType)(query);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "lnsConfigPanel"
  }, layerIds.map((layerId, layerIndex) => {
    const {
      hidden,
      groups
    } = activeVisualization.getConfiguration({
      layerId,
      frame: props.framePublicAPI,
      state: visualization.state
    });
    return !hidden && /*#__PURE__*/_react.default.createElement(_layer_panel.LayerPanel, (0, _extends2.default)({}, props, {
      dimensionGroups: groups,
      activeVisualization: activeVisualization,
      registerNewLayerRef: registerNewLayerRef,
      key: layerId,
      layerId: layerId,
      layerIndex: layerIndex,
      visualizationState: visualization.state,
      updateVisualization: setVisualizationState,
      updateDatasource: updateDatasource,
      updateDatasourceAsync: updateDatasourceAsync,
      onChangeIndexPattern: args => {
        var _activeVisualization$, _activeVisualization$2;
        onChangeIndexPattern(args);
        const layersToRemove = (_activeVisualization$ = (_activeVisualization$2 = activeVisualization.getLayersToRemoveOnIndexPatternChange) === null || _activeVisualization$2 === void 0 ? void 0 : _activeVisualization$2.call(activeVisualization, visualization.state)) !== null && _activeVisualization$ !== void 0 ? _activeVisualization$ : [];
        layersToRemove.forEach(id => onRemoveLayer(id));
      },
      updateAll: updateAll,
      addLayer: addLayer,
      isOnlyLayer: (0, _utils.getRemoveOperation)(activeVisualization, visualization.state, layerId, layerIds.length) === 'clear',
      onEmptyDimensionAdd: (columnId, {
        groupId
      }) => {
        var _datasourceMap$active;
        // avoid state update if the datasource does not support initializeDimension
        if (activeDatasourceId != null && (_datasourceMap$active = datasourceMap[activeDatasourceId]) !== null && _datasourceMap$active !== void 0 && _datasourceMap$active.initializeDimension) {
          dispatchLens((0, _state_management.setLayerDefaultDimension)({
            layerId,
            columnId,
            groupId
          }));
        }
      },
      onCloneLayer: () => {
        dispatchLens((0, _state_management.cloneLayer)({
          layerId
        }));
      },
      onRemoveLayer: onRemoveLayer,
      onRemoveDimension: dimensionProps => {
        var _props$framePublicAPI2;
        const datasourcePublicAPI = (_props$framePublicAPI2 = props.framePublicAPI.datasourceLayers) === null || _props$framePublicAPI2 === void 0 ? void 0 : _props$framePublicAPI2[layerId];
        const datasourceId = datasourcePublicAPI === null || datasourcePublicAPI === void 0 ? void 0 : datasourcePublicAPI.datasourceId;
        dispatchLens((0, _lens_slice.removeDimension)({
          ...dimensionProps,
          datasourceId
        }));
      },
      toggleFullscreen: toggleFullscreen,
      indexPatternService: indexPatternService
    }));
  }), !hideAddLayerButton && /*#__PURE__*/_react.default.createElement(_add_layer.AddLayerButton, {
    visualization: activeVisualization,
    visualizationState: visualization.state,
    layersMeta: props.framePublicAPI,
    onAddLayerClick: layerType => addLayer(layerType)
  }));
}