"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onDropForVisualization = onDropForVisualization;
exports.shouldRemoveSource = shouldRemoveSource;
var _types = require("../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function shouldRemoveSource(source, dropType) {
  return (0, _types.isOperation)(source) && (dropType === 'move_compatible' || dropType === 'move_incompatible' || dropType === 'combine_incompatible' || dropType === 'combine_compatible' || dropType === 'replace_compatible' || dropType === 'replace_incompatible');
}
function onDropForVisualization(props, activeVisualization) {
  const {
    prevState,
    target,
    frame,
    source,
    group
  } = props;
  const {
    layerId,
    columnId,
    groupId
  } = target;
  const previousColumn = (0, _types.isOperation)(source) && group !== null && group !== void 0 && group.requiresPreviousColumnOnDuplicate ? source.columnId : undefined;
  const newVisState = activeVisualization.setDimension({
    columnId,
    groupId,
    layerId,
    prevState,
    previousColumn,
    frame
  });
  return newVisState;
}