"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DimensionButton = DimensionButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _dimension_button_icon = require("../dimension_button_icon");
var _palette_indicator = require("../palette_indicator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const triggerLinkA11yText = label => _i18n.i18n.translate('xpack.lens.configure.editConfig', {
  defaultMessage: 'Edit {label} configuration',
  values: {
    label
  }
});
function DimensionButton({
  group,
  children,
  onClick,
  onRemoveClick,
  accessorConfig,
  label,
  message,
  ...otherProps // from Drag&Drop integration
}) {
  return /*#__PURE__*/_react.default.createElement("div", otherProps, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (message === null || message === void 0 ? void 0 : message.shortMessage) || (message === null || message === void 0 ? void 0 : message.longMessage) || undefined,
    position: "left"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    className: "lnsLayerPanel__dimensionLink",
    "data-test-subj": "lnsLayerPanel-dimensionLink",
    onClick: () => onClick(accessorConfig.columnId),
    "aria-label": triggerLinkA11yText(label),
    title: triggerLinkA11yText(label),
    color: (message === null || message === void 0 ? void 0 : message.severity) === 'error' ? 'danger' : (message === null || message === void 0 ? void 0 : message.severity) === 'warning' ? 'warning' : 'text'
  }, /*#__PURE__*/_react.default.createElement(_dimension_button_icon.DimensionButtonIcon, {
    message: message,
    accessorConfig: accessorConfig
  }, children))))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    className: "lnsLayerPanel__dimensionRemove",
    "data-test-subj": "indexPattern-dimension-remove",
    iconType: "trash",
    size: "xs",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.lens.indexPattern.removeColumnLabel', {
      defaultMessage: 'Remove configuration from "{groupLabel}"',
      values: {
        groupLabel: group.groupLabel
      }
    }),
    title: _i18n.i18n.translate('xpack.lens.indexPattern.removeColumnLabel', {
      defaultMessage: 'Remove configuration from "{groupLabel}"',
      values: {
        groupLabel: group.groupLabel
      }
    }),
    onClick: () => onRemoveClick(accessorConfig.columnId),
    css: (0, _react2.css)`
          color: ${_uiTheme.euiThemeVars.euiTextSubduedColor};
          &:hover {
            color: ${_uiTheme.euiThemeVars.euiColorDangerText};
          }
        `
  }), /*#__PURE__*/_react.default.createElement(_palette_indicator.PaletteIndicator, {
    accessorConfig: accessorConfig
  }));
}