"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerButton = AddLayerButton;
exports.getLayerType = getLayerType;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/expression-xy-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLayerType(visualization, state, layerId) {
  return visualization.getLayerType(layerId, state) || _public.LayerTypes.DATA;
}
function AddLayerButton({
  visualization,
  visualizationState,
  onAddLayerClick,
  layersMeta
}) {
  const [showLayersChoice, toggleLayersChoice] = (0, _react.useState)(false);
  const supportedLayers = (0, _react.useMemo)(() => {
    var _visualization$getSup, _visualization$getSup2;
    if (!visualization.appendLayer || !visualizationState) {
      return null;
    }
    return (_visualization$getSup = visualization.getSupportedLayers) === null || _visualization$getSup === void 0 ? void 0 : (_visualization$getSup2 = _visualization$getSup.call(visualization, visualizationState, layersMeta)) === null || _visualization$getSup2 === void 0 ? void 0 : _visualization$getSup2.filter(({
      canAddViaMenu: hideFromMenu
    }) => !hideFromMenu);
  }, [visualization, visualizationState, layersMeta]);
  if (supportedLayers == null || !supportedLayers.length) {
    return null;
  }
  if (supportedLayers.length === 1) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      display: "block",
      title: _i18n.i18n.translate('xpack.lens.xyChart.addLayer', {
        defaultMessage: 'Add a layer'
      }),
      content: _i18n.i18n.translate('xpack.lens.xyChart.addLayerTooltip', {
        defaultMessage: 'Use multiple layers to combine visualization types or visualize different data views.'
      }),
      position: "bottom"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fullWidth: true,
      "data-test-subj": "lnsLayerAddButton",
      "aria-label": _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
        defaultMessage: 'Add layer'
      }),
      onClick: () => onAddLayerClick(supportedLayers[0].type),
      iconType: "layers"
    }, _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
      defaultMessage: 'Add layer'
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    display: "block",
    "data-test-subj": "lnsConfigPanel__addLayerPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fullWidth: true,
      "data-test-subj": "lnsLayerAddButton",
      "aria-label": _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
        defaultMessage: 'Add layer'
      }),
      onClick: () => toggleLayersChoice(!showLayersChoice),
      iconType: "layers"
    }, _i18n.i18n.translate('xpack.lens.configPanel.addLayerButton', {
      defaultMessage: 'Add layer'
    })),
    isOpen: showLayersChoice,
    closePopover: () => toggleLayersChoice(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: [{
      id: 0,
      title: _i18n.i18n.translate('xpack.lens.configPanel.selectLayerType', {
        defaultMessage: 'Select layer type'
      }),
      width: 300,
      items: supportedLayers.map(({
        type,
        label,
        icon,
        disabled,
        toolTipContent
      }) => {
        return {
          toolTipContent,
          disabled,
          name: type === _public.LayerTypes.ANNOTATIONS ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            gutterSize: "m"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", {
            className: "lnsLayerAddButton__label"
          }, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
            className: "lnsLayerAddButton__techBadge",
            color: "hollow",
            isDisabled: disabled
          }, _i18n.i18n.translate('xpack.lens.configPanel.experimentalLabel', {
            defaultMessage: 'Technical preview'
          })))) : /*#__PURE__*/_react.default.createElement("span", {
            className: "lnsLayerAddButtonLabel"
          }, label),
          className: 'lnsLayerAddButton',
          icon: icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            size: "m",
            type: icon
          }),
          ['data-test-subj']: `lnsLayerAddButton-${type}`,
          onClick: () => {
            onAddLayerClick(type);
            toggleLayersChoice(false);
          }
        };
      })
    }]
  }));
}