"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RandomSamplingIcon = RandomSamplingIcon;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RandomSamplingIcon({
  title,
  titleId,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement("svg", (0, _extends2.default)({
    width: "15",
    height: "16",
    viewBox: "0 0 15 16",
    xmlns: "http://www.w3.org/2000/svg",
    "aria-labelledby": titleId
  }, props), title ? /*#__PURE__*/_react.default.createElement("title", {
    id: titleId
  }, title) : null, /*#__PURE__*/_react.default.createElement("path", {
    d: "M1 0C0.447715 0 0 0.447715 0 1V14C0 14.5523 0.447715 15 1 15H7.67099C7.54918 14.9013 7.43133 14.7953 7.31802 14.682C7.10539 14.4693 6.91848 14.2407 6.75731 14H1V1H8V4.5C8 4.77614 8.22386 5 8.5 5H12V7.25625C12.3483 7.3791 12.6846 7.54612 13 7.75731V4C13 3.73478 12.8946 3.48043 12.7071 3.29289L9.70711 0.292893C9.51957 0.105357 9.26522 0 9 0H1Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M10.5 13C11.3284 13 12 12.3284 12 11.5C12 10.6716 11.3284 10 10.5 10C9.67157 10 9 10.6716 9 11.5C9 12.3284 9.67157 13 10.5 13Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    fillRule: "evenodd",
    clipRule: "evenodd",
    d: "M14.1465 15.8536L12.5962 14.3033C11.9771 14.7674 11.2393 14.9997 10.5013 15H10.4987C9.61445 14.9997 8.7303 14.6663 8.05051 14L8.02517 13.9749C6.65833 12.608 6.65833 10.392 8.02517 9.02513C9.392 7.65829 11.6081 7.65829 12.9749 9.02513C14.2217 10.2719 14.3312 12.2253 13.3034 13.5963L14.8536 15.1464C15.0489 15.3417 15.0489 15.6583 14.8536 15.8535C14.6584 16.0488 14.3418 16.0488 14.1465 15.8536ZM12.2678 13.9749L12.5962 14.3033C11.9805 14.7648 11.2474 14.997 10.5135 14.9998C10.7834 14.9927 11.0001 14.7716 11.0001 14.5C11.0001 14.2239 10.7762 14 10.5001 14C9.85948 14 9.22053 13.756 8.73227 13.2678C7.75596 12.2915 7.75596 10.7085 8.73227 9.73223C9.70858 8.75592 11.2915 8.75592 12.2678 9.73223C13.2441 10.7085 13.2441 12.2915 12.2678 13.2678C12.174 13.3615 12.1214 13.4887 12.1214 13.6213C12.1214 13.7539 12.174 13.8811 12.2678 13.9749Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M3 2.5C3 2.77614 2.77614 3 2.5 3C2.22386 3 2 2.77614 2 2.5C2 2.22386 2.22386 2 2.5 2C2.77614 2 3 2.22386 3 2.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.5 5C2.77614 5 3 4.77614 3 4.5C3 4.22386 2.77614 4 2.5 4C2.22386 4 2 4.22386 2 4.5C2 4.77614 2.22386 5 2.5 5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M3 6.5C3 6.77614 2.77614 7 2.5 7C2.22386 7 2 6.77614 2 6.5C2 6.22386 2.22386 6 2.5 6C2.77614 6 3 6.22386 3 6.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.5 9C2.77614 9 3 8.77614 3 8.5C3 8.22386 2.77614 8 2.5 8C2.22386 8 2 8.22386 2 8.5C2 8.77614 2.22386 9 2.5 9Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M3 10.5C3 10.7761 2.77614 11 2.5 11C2.22386 11 2 10.7761 2 10.5C2 10.2239 2.22386 10 2.5 10C2.77614 10 3 10.2239 3 10.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M3 12.5C3 12.7761 2.77614 13 2.5 13C2.22386 13 2 12.7761 2 12.5C2 12.2239 2.22386 12 2.5 12C2.77614 12 3 12.2239 3 12.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M4.5 9C4.77614 9 5 8.77614 5 8.5C5 8.22386 4.77614 8 4.5 8C4.22386 8 4 8.22386 4 8.5C4 8.77614 4.22386 9 4.5 9Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M5 6.5C5 6.77614 4.77614 7 4.5 7C4.22386 7 4 6.77614 4 6.5C4 6.22386 4.22386 6 4.5 6C4.77614 6 5 6.22386 5 6.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M4.5 5C4.77614 5 5 4.77614 5 4.5C5 4.22386 4.77614 4 4.5 4C4.22386 4 4 4.22386 4 4.5C4 4.77614 4.22386 5 4.5 5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M5 2.5C5 2.77614 4.77614 3 4.5 3C4.22386 3 4 2.77614 4 2.5C4 2.22386 4.22386 2 4.5 2C4.77614 2 5 2.22386 5 2.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6.5 5C6.77614 5 7 4.77614 7 4.5C7 4.22386 6.77614 4 6.5 4C6.22386 4 6 4.22386 6 4.5C6 4.77614 6.22386 5 6.5 5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M7 2.5C7 2.77614 6.77614 3 6.5 3C6.22386 3 6 2.77614 6 2.5C6 2.22386 6.22386 2 6.5 2C6.77614 2 7 2.22386 7 2.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M6.5 7C6.77614 7 7 6.77614 7 6.5C7 6.22386 6.77614 6 6.5 6C6.22386 6 6 6.22386 6 6.5C6 6.77614 6.22386 7 6.5 7Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M9 6.5C9 6.77614 8.77614 7 8.5 7C8.22386 7 8 6.77614 8 6.5C8 6.22386 8.22386 6 8.5 6C8.77614 6 9 6.22386 9 6.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M10.5 7C10.7761 7 11 6.77614 11 6.5C11 6.22386 10.7761 6 10.5 6C10.2239 6 10 6.22386 10 6.5C10 6.77614 10.2239 7 10.5 7Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M7 8.5C7 8.77614 6.77614 9 6.5 9C6.22386 9 6 8.77614 6 8.5C6 8.22386 6.22386 8 6.5 8C6.77614 8 7 8.22386 7 8.5Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M4.5 11C4.77614 11 5 10.7761 5 10.5C5 10.2239 4.77614 10 4.5 10C4.22386 10 4 10.2239 4 10.5C4 10.7761 4.22386 11 4.5 11Z"
  }), /*#__PURE__*/_react.default.createElement("path", {
    d: "M5 12.5C5 12.7761 4.77614 13 4.5 13C4.22386 13 4 12.7761 4 12.5C4 12.2239 4.22386 12 4.5 12C4.77614 12 5 12.2239 5 12.5Z"
  }));
}