"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValuesInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../../shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValuesInput = ({
  value,
  onChange,
  minValue = 1,
  maxValue = 10000,
  label = _i18n.i18n.translate('xpack.lens.indexPattern.terms.size', {
    defaultMessage: 'Number of values'
  }),
  disabled
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)(String(value));
  (0, _shared_components.useDebounceWithOptions)(() => {
    if (inputValue === '') {
      return;
    }
    const inputNumber = Number(inputValue);
    onChange(Math.min(maxValue, Math.max(inputNumber, minValue)));
  }, {
    skipFirstRender: true
  }, 256, [inputValue]);
  const isEmptyString = inputValue === '';
  const isHigherThanMax = !isEmptyString && Number(inputValue) > maxValue;
  const isLowerThanMin = !isEmptyString && Number(inputValue) < minValue;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "rowCompressed",
    fullWidth: true,
    isInvalid: isHigherThanMax || isLowerThanMin,
    error: isHigherThanMax ? [_i18n.i18n.translate('xpack.lens.indexPattern.terms.sizeLimitMax', {
      defaultMessage: 'Value is higher than the maximum {max}, the maximum value is used instead.',
      values: {
        max: maxValue
      }
    })] : isLowerThanMin ? [_i18n.i18n.translate('xpack.lens.indexPattern.terms.sizeLimitMin', {
      defaultMessage: 'Value is lower than the minimum {min}, the minimum value is used instead.',
      values: {
        min: minValue
      }
    })] : null
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: minValue,
    max: maxValue,
    step: 1,
    value: inputValue,
    compressed: true,
    isInvalid: isHigherThanMax || isLowerThanMin,
    disabled: disabled,
    onChange: ({
      currentTarget
    }) => setInputValue(currentTarget.value),
    "aria-label": label,
    onBlur: () => {
      if (inputValue === '') {
        return setInputValue(String(value));
      }
      const inputNumber = Number(inputValue);
      setInputValue(String(Math.min(maxValue, Math.max(inputNumber, minValue))));
    }
  }));
};
exports.ValuesInput = ValuesInput;