"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.staticValueOperation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../shared_components");
var _helpers = require("./helpers");
var _layer_helpers = require("../layer_helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultLabel = _i18n.i18n.translate('xpack.lens.indexPattern.staticValueLabelDefault', {
  defaultMessage: 'Static value'
});
const defaultValue = 100;
function isEmptyValue(value) {
  return value == null || value === '';
}
function ofName(value) {
  if (isEmptyValue(value)) {
    return defaultLabel;
  }
  return _i18n.i18n.translate('xpack.lens.indexPattern.staticValueLabelWithValue', {
    defaultMessage: 'Static value: {value}',
    values: {
      value
    }
  });
}
function isStaticValueColumnLike(col) {
  return Boolean('params' in col && col.params && 'value' in col.params);
}
const staticValueOperation = {
  type: 'static_value',
  displayName: defaultLabel,
  getDefaultLabel: column => ofName(column.params.value),
  input: 'managedReference',
  hidden: true,
  getDisabledStatus(indexPattern) {
    return undefined;
  },
  getErrorMessage(layer, columnId) {
    const column = layer.columns[columnId];
    return column.params.value != null && !(0, _helpers.isValidNumber)(column.params.value) ? [_i18n.i18n.translate('xpack.lens.indexPattern.staticValueError', {
      defaultMessage: 'The static value of {value} is not a valid number',
      values: {
        value: column.params.value
      }
    })] : undefined;
  },
  getPossibleOperation() {
    return {
      dataType: 'number',
      isBucketed: false,
      scale: 'ratio',
      isStaticValue: true
    };
  },
  toExpression: (layer, columnId) => {
    var _params$value;
    const currentColumn = layer.columns[columnId];
    const params = currentColumn.params;
    // TODO: improve this logic
    const useDisplayLabel = currentColumn.label !== defaultLabel;
    const label = (0, _helpers.isValidNumber)(params.value) ? useDisplayLabel ? currentColumn.label : (_params$value = params === null || params === void 0 ? void 0 : params.value) !== null && _params$value !== void 0 ? _params$value : defaultLabel : defaultLabel;
    return [{
      type: 'function',
      function: (0, _helpers.isValidNumber)(params.value) ? 'mathColumn' : 'mapColumn',
      arguments: {
        id: [columnId],
        name: [label || defaultLabel],
        expression: [String((0, _helpers.isValidNumber)(params.value) ? params.value : defaultValue)]
      }
    }];
  },
  buildColumn({
    previousColumn,
    layer,
    indexPattern
  }, columnParams, operationDefinitionMap) {
    var _previousParams$value;
    const existingStaticValue = previousColumn && isStaticValueColumnLike(previousColumn) && (0, _helpers.isValidNumber)(previousColumn.params.value) ? previousColumn.params.value : undefined;
    const previousParams = {
      ...{
        value: existingStaticValue
      },
      ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn),
      ...columnParams
    };
    return {
      label: ofName(previousParams.value),
      dataType: 'number',
      operationType: 'static_value',
      isStaticValue: true,
      isBucketed: false,
      scale: 'ratio',
      params: {
        ...previousParams,
        value: String((_previousParams$value = previousParams.value) !== null && _previousParams$value !== void 0 ? _previousParams$value : defaultValue)
      },
      references: []
    };
  },
  isTransferable: column => {
    return true;
  },
  createCopy(layers, source, target) {
    const currentColumn = layers[source.layerId].columns[source.columnId];
    const targetLayer = layers[target.layerId];
    const columns = {
      ...targetLayer.columns,
      [target.columnId]: {
        ...currentColumn
      }
    };
    return {
      ...layers,
      [target.layerId]: {
        ...targetLayer,
        columns,
        columnOrder: (0, _layer_helpers.getColumnOrder)({
          ...targetLayer,
          columns
        })
      }
    };
  },
  paramEditor: function StaticValueEditor({
    paramEditorUpdater,
    currentColumn,
    columnId,
    activeData,
    layerId,
    paramEditorCustomProps
  }) {
    var _currentColumn$params, _activeData$layerId, _activeData$layerId$r, _currentColumn$params2, _paramEditorCustomPro;
    const onChange = (0, _react.useCallback)(newValue => {
      // even if debounced it's triggering for empty string with the previous valid value
      if (currentColumn.params.value === newValue) {
        return;
      }
      // Because of upstream specific UX flows, we need fresh layer state here
      // so need to use the updater pattern
      paramEditorUpdater(newLayer => {
        const newColumn = newLayer.columns[columnId];
        return {
          ...newLayer,
          columns: {
            ...newLayer.columns,
            [columnId]: {
              ...newColumn,
              label: newColumn !== null && newColumn !== void 0 && newColumn.customLabel ? newColumn.label : ofName(newValue),
              params: {
                ...newColumn.params,
                value: newValue
              }
            }
          }
        };
      });
    }, [columnId, paramEditorUpdater, currentColumn === null || currentColumn === void 0 ? void 0 : (_currentColumn$params = currentColumn.params) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.value]);

    // Pick the data from the current activeData (to be used when the current operation is not static_value)
    const activeDataValue = (activeData === null || activeData === void 0 ? void 0 : (_activeData$layerId = activeData[layerId]) === null || _activeData$layerId === void 0 ? void 0 : (_activeData$layerId$r = _activeData$layerId.rows) === null || _activeData$layerId$r === void 0 ? void 0 : _activeData$layerId$r.length) === 1 && activeData[layerId].rows[0][columnId];
    const fallbackValue = (currentColumn === null || currentColumn === void 0 ? void 0 : currentColumn.operationType) !== 'static_value' && activeDataValue != null ? activeDataValue : String(defaultValue);
    const {
      inputValue,
      handleInputChange
    } = (0, _shared_components.useDebouncedValue)({
      value: (currentColumn === null || currentColumn === void 0 ? void 0 : (_currentColumn$params2 = currentColumn.params) === null || _currentColumn$params2 === void 0 ? void 0 : _currentColumn$params2.value) || fallbackValue,
      onChange
    }, {
      allowFalsyValue: true
    });
    const onChangeHandler = (0, _react.useCallback)(e => {
      const value = e.currentTarget.value;
      handleInputChange((0, _helpers.isValidNumber)(value) ? value : undefined);
    }, [handleInputChange]);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (paramEditorCustomProps === null || paramEditorCustomProps === void 0 ? void 0 : (_paramEditorCustomPro = paramEditorCustomProps.labels) === null || _paramEditorCustomPro === void 0 ? void 0 : _paramEditorCustomPro[0]) || defaultLabel,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      fullWidth: true,
      "data-test-subj": "lns-indexPattern-static_value-input",
      compressed: true,
      value: inputValue !== null && inputValue !== void 0 ? inputValue : '',
      onChange: onChangeHandler,
      step: "any"
    }));
  }
};
exports.staticValueOperation = staticValueOperation;