"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_components = require("../../../../../shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LabelInput = ({
  value,
  onChange,
  placeholder,
  inputRef,
  onSubmit,
  dataTestSubj,
  compressed
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _shared_components.useDebouncedValue)({
    value,
    onChange
  }, {
    allowFalsyValue: true
  });
  const localKeyHold = (0, _react.useRef)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": dataTestSubj || 'lens-labelInput',
    value: inputValue,
    onChange: e => handleInputChange(e.target.value),
    fullWidth: true,
    placeholder: placeholder || '',
    inputRef: node => {
      if (inputRef && node) {
        inputRef.current = node;
      }
    },
    onKeyDown: () => {
      localKeyHold.current = true;
    },
    onKeyUp: ({
      key
    }) => {
      // only submit on key up in case the user started the keypress while the input was focused
      if (localKeyHold.current && _eui.keys.ENTER === key && onSubmit) {
        onSubmit();
      }
      localKeyHold.current = false;
    },
    prepend: _i18n.i18n.translate('xpack.lens.labelInput.label', {
      defaultMessage: 'Label'
    }),
    compressed: compressed
  });
};
exports.LabelInput = LabelInput;