"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormRow = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./form_row.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FormRow = ({
  children,
  label,
  isInline,
  ...props
}) => {
  return !isInline ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, props, {
    label: label
  }), children) : /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": props['data-test-subj']
  }, /*#__PURE__*/_react.default.cloneElement(children, {
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      className: "lnsIndexPatternDimensionEditor__labelCustomRank"
    }, label)
  }));
};
exports.FormRow = FormRow;