"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "averageOperation", {
  enumerable: true,
  get: function () {
    return _metrics.averageOperation;
  }
});
Object.defineProperty(exports, "countOperation", {
  enumerable: true,
  get: function () {
    return _count.countOperation;
  }
});
Object.defineProperty(exports, "counterRateOperation", {
  enumerable: true,
  get: function () {
    return _calculations.counterRateOperation;
  }
});
Object.defineProperty(exports, "cumulativeSumOperation", {
  enumerable: true,
  get: function () {
    return _calculations.cumulativeSumOperation;
  }
});
Object.defineProperty(exports, "dateHistogramOperation", {
  enumerable: true,
  get: function () {
    return _date_histogram.dateHistogramOperation;
  }
});
Object.defineProperty(exports, "derivativeOperation", {
  enumerable: true,
  get: function () {
    return _calculations.derivativeOperation;
  }
});
Object.defineProperty(exports, "filtersOperation", {
  enumerable: true,
  get: function () {
    return _filters.filtersOperation;
  }
});
Object.defineProperty(exports, "formulaOperation", {
  enumerable: true,
  get: function () {
    return _formula2.formulaOperation;
  }
});
Object.defineProperty(exports, "lastValueOperation", {
  enumerable: true,
  get: function () {
    return _last_value.lastValueOperation;
  }
});
Object.defineProperty(exports, "maxOperation", {
  enumerable: true,
  get: function () {
    return _metrics.maxOperation;
  }
});
Object.defineProperty(exports, "minOperation", {
  enumerable: true,
  get: function () {
    return _metrics.minOperation;
  }
});
Object.defineProperty(exports, "movingAverageOperation", {
  enumerable: true,
  get: function () {
    return _calculations.movingAverageOperation;
  }
});
exports.operationDefinitions = exports.operationDefinitionMap = void 0;
Object.defineProperty(exports, "overallAverageOperation", {
  enumerable: true,
  get: function () {
    return _calculations.overallAverageOperation;
  }
});
Object.defineProperty(exports, "overallMaxOperation", {
  enumerable: true,
  get: function () {
    return _calculations.overallMaxOperation;
  }
});
Object.defineProperty(exports, "overallMinOperation", {
  enumerable: true,
  get: function () {
    return _calculations.overallMinOperation;
  }
});
Object.defineProperty(exports, "overallSumOperation", {
  enumerable: true,
  get: function () {
    return _calculations.overallSumOperation;
  }
});
Object.defineProperty(exports, "percentileOperation", {
  enumerable: true,
  get: function () {
    return _percentile.percentileOperation;
  }
});
Object.defineProperty(exports, "percentileRanksOperation", {
  enumerable: true,
  get: function () {
    return _percentile_ranks.percentileRanksOperation;
  }
});
Object.defineProperty(exports, "rangeOperation", {
  enumerable: true,
  get: function () {
    return _ranges.rangeOperation;
  }
});
exports.renameOperationsMapping = void 0;
Object.defineProperty(exports, "standardDeviationOperation", {
  enumerable: true,
  get: function () {
    return _metrics.standardDeviationOperation;
  }
});
Object.defineProperty(exports, "staticValueOperation", {
  enumerable: true,
  get: function () {
    return _static_value.staticValueOperation;
  }
});
Object.defineProperty(exports, "sumOperation", {
  enumerable: true,
  get: function () {
    return _metrics.sumOperation;
  }
});
Object.defineProperty(exports, "termsOperation", {
  enumerable: true,
  get: function () {
    return _terms.termsOperation;
  }
});
Object.defineProperty(exports, "timeScaleOperation", {
  enumerable: true,
  get: function () {
    return _calculations.timeScaleOperation;
  }
});
var _terms = require("./terms");
var _filters = require("./filters");
var _cardinality = require("./cardinality");
var _percentile = require("./percentile");
var _percentile_ranks = require("./percentile_ranks");
var _metrics = require("./metrics");
var _date_histogram = require("./date_histogram");
var _calculations = require("./calculations");
var _count = require("./count");
var _formula = require("./formula");
var _static_value = require("./static_value");
var _last_value = require("./last_value");
var _ranges = require("./ranges");
var _formula2 = require("./formula/formula");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// List of all operation definitions registered to this data source.
// If you want to implement a new operation, add the definition to this array and
// the column type to the `GenericIndexPatternColumn` union type below.
const internalOperationDefinitions = [_filters.filtersOperation, _terms.termsOperation, _date_histogram.dateHistogramOperation, _metrics.minOperation, _metrics.maxOperation, _metrics.averageOperation, _cardinality.cardinalityOperation, _metrics.sumOperation, _metrics.standardDeviationOperation, _metrics.medianOperation, _percentile.percentileOperation, _percentile_ranks.percentileRanksOperation, _last_value.lastValueOperation, _count.countOperation, _ranges.rangeOperation, _calculations.cumulativeSumOperation, _calculations.counterRateOperation, _calculations.derivativeOperation, _calculations.movingAverageOperation, _formula.mathOperation, _formula.formulaOperation, _calculations.overallSumOperation, _calculations.overallMinOperation, _calculations.overallMaxOperation, _calculations.overallAverageOperation, _static_value.staticValueOperation, _calculations.timeScaleOperation];
/**
 * List of all available operation definitions
 */
const operationDefinitions = internalOperationDefinitions;

/**
 * Map of all operation visible to consumers (e.g. the dimension panel).
 * This simplifies the type of the map and makes it a simple list of unspecified
 * operations definitions, because typescript can't infer the type correctly in most
 * situations.
 *
 * If you need a specifically typed version of an operation (e.g. explicitly working with terms),
 * you should import the definition directly from this file
 * (e.g. `import { termsOperation } from './operations/definitions'`). This map is
 * intended to be used in situations where the operation type is not known during compile time.
 */
exports.operationDefinitions = operationDefinitions;
const operationDefinitionMap = internalOperationDefinitions.reduce((definitionMap, definition) => ({
  ...definitionMap,
  [definition.type]: definition
}), {});

/**
 * Cannot map the prev names, but can guarantee the new names are matching up using the type system
 */
exports.operationDefinitionMap = operationDefinitionMap;
const renameOperationsMapping = {
  avg: 'average',
  cardinality: 'unique_count'
};
exports.renameOperationsMapping = renameOperationsMapping;