"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterPopover = void 0;
require("./filter_popover.scss");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../../shared_components");
var _ = require(".");
var _shared_components2 = require("../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Need to keep it separate to make it work Jest mocks in dimension_panel tests
// import { QueryInput } from '../../../../shared_components/query_input';

const FilterPopover = ({
  filter,
  setFilter,
  indexPattern,
  button,
  isOpen,
  triggerClose
}) => {
  const inputRef = _react.default.useRef();
  const setFilterLabel = label => setFilter({
    ...filter,
    label
  });
  const setFilterQuery = input => setFilter({
    ...filter,
    input
  });
  const getPlaceholder = query => {
    if (query === '') {
      return _.defaultLabel;
    }
    if (query === 'object') return JSON.stringify(query);else {
      return String(query);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "indexPattern-filters-existingFilterContainer",
    anchorClassName: "eui-fullWidth",
    panelClassName: "lnsIndexPatternDimensionEditor__filtersEditor",
    isOpen: isOpen,
    ownFocus: true,
    closePopover: triggerClose,
    button: button
  }, /*#__PURE__*/_react.default.createElement(_shared_components.QueryInput, {
    isInvalid: !(0, _shared_components.isQueryValid)(filter.input, indexPattern),
    value: filter.input,
    indexPattern: indexPattern.id ? {
      type: 'id',
      value: indexPattern.id
    } : {
      type: 'title',
      value: indexPattern.title
    },
    disableAutoFocus: true,
    onChange: setFilterQuery,
    onSubmit: () => {
      if (inputRef.current) inputRef.current.focus();
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_shared_components2.LabelInput, {
    value: filter.label || '',
    onChange: setFilterLabel,
    placeholder: getPlaceholder(filter.input.query),
    inputRef: inputRef,
    onSubmit: triggerClose,
    dataTestSubj: "indexPattern-filters-label"
  }));
};
exports.FilterPopover = FilterPopover;