"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.movingAverageOperation = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_components = require("../../../../../shared_components");
var _utils = require("./utils");
var _layer_helpers = require("../../layer_helpers");
var _helpers = require("../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ofName = (0, _utils.buildLabelFunction)(name => {
  return _i18n.i18n.translate('xpack.lens.indexPattern.movingAverageOf', {
    defaultMessage: 'Moving average of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
        defaultMessage: '(incomplete)'
      })
    }
  });
});
const WINDOW_DEFAULT_VALUE = 5;
const movingAverageOperation = {
  type: 'moving_average',
  priority: 1,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage', {
    defaultMessage: 'Moving average'
  }),
  input: 'fullReference',
  selectionStyle: 'full',
  requiredReferences: [{
    input: ['field', 'managedReference'],
    validateMetadata: meta => meta.dataType === 'number' && !meta.isBucketed
  }],
  operationParams: [{
    name: 'window',
    type: 'number',
    required: false,
    defaultValue: WINDOW_DEFAULT_VALUE
  }],
  getPossibleOperation: indexPattern => {
    if ((0, _utils.hasDateField)(indexPattern)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  getDefaultLabel: (column, indexPattern, columns) => {
    var _columns$column$refer;
    return ofName((_columns$column$refer = columns[column.references[0]]) === null || _columns$column$refer === void 0 ? void 0 : _columns$column$refer.label, column.timeScale, column.timeShift);
  },
  toExpression: (layer, columnId) => {
    return (0, _utils.dateBasedOperationToExpression)(layer, columnId, 'moving_average', {
      window: [layer.columns[columnId].params.window]
    });
  },
  buildColumn: ({
    referenceIds,
    previousColumn,
    layer
  }, columnParams) => {
    var _columnParams$window;
    const metric = layer.columns[referenceIds[0]];
    const window = (_columnParams$window = columnParams === null || columnParams === void 0 ? void 0 : columnParams.window) !== null && _columnParams$window !== void 0 ? _columnParams$window : WINDOW_DEFAULT_VALUE;
    return {
      label: ofName(metric === null || metric === void 0 ? void 0 : metric.label, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      dataType: 'number',
      operationType: 'moving_average',
      isBucketed: false,
      scale: 'ratio',
      references: referenceIds,
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      timeScale: previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale,
      params: {
        window,
        ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn)
      }
    };
  },
  paramEditor: MovingAverageParamEditor,
  isTransferable: (column, newIndexPattern) => {
    return (0, _utils.hasDateField)(newIndexPattern);
  },
  getErrorMessage: (layer, columnId) => {
    return (0, _utils.getErrorsForDateReference)(layer, columnId, _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage', {
      defaultMessage: 'Moving average'
    }));
  },
  helpComponent: () => /*#__PURE__*/_react.default.createElement(MovingAveragePopup, null),
  helpComponentTitle: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.titleHelp', {
    defaultMessage: 'How moving average works'
  }),
  getDisabledStatus(indexPattern, layer, layerType) {
    var _checkForDateHistogra;
    const opName = _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage', {
      defaultMessage: 'Moving average'
    });
    if (layerType) {
      const dataLayerErrors = (0, _utils.checkForDataLayerType)(layerType, opName);
      if (dataLayerErrors) {
        return dataLayerErrors.join(', ');
      }
    }
    return (_checkForDateHistogra = (0, _utils.checkForDateHistogram)(layer, opName)) === null || _checkForDateHistogra === void 0 ? void 0 : _checkForDateHistogra.join(', ');
  },
  timeScalingMode: 'optional',
  filterable: true,
  documentation: {
    section: 'calculation',
    signature: _i18n.i18n.translate('xpack.lens.indexPattern.moving_average.signature', {
      defaultMessage: 'metric: number, [window]: number'
    }),
    description: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.documentation.markdown', {
      defaultMessage: `
Calculates the moving average of a metric over time, averaging the last n-th values to calculate the current value. To use this function, you need to configure a date histogram dimension as well.
The default window value is {defaultValue}.

This calculation will be done separately for separate series defined by filters or top values dimensions.

Takes a named parameter \`window\` which specifies how many last values to include in the average calculation for the current value.

Example: Smooth a line of measurements:
\`moving_average(sum(bytes), window=5)\`
      `,
      values: {
        defaultValue: WINDOW_DEFAULT_VALUE
      }
    })
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.documentation.quick', {
    defaultMessage: `
      The average of a moving window of values over time.
      `
  }),
  shiftable: true
};
exports.movingAverageOperation = movingAverageOperation;
function MovingAverageParamEditor({
  layer,
  paramEditorUpdater,
  currentColumn,
  columnId
}) {
  const [inputValue, setInputValue] = (0, _react.useState)(String(currentColumn.params.window));
  (0, _shared_components.useDebounceWithOptions)(() => {
    if (!(0, _helpers.isValidNumber)(inputValue, true, undefined, 1)) return;
    const inputNumber = parseInt(inputValue, 10);
    paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
      layer,
      columnId,
      paramName: 'window',
      value: inputNumber
    }));
  }, {
    skipFirstRender: true
  }, 256, [inputValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.indexPattern.movingAverage.window', {
      defaultMessage: 'Window size'
    }),
    display: "rowCompressed",
    fullWidth: true,
    isInvalid: !(0, _helpers.isValidNumber)(inputValue)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    compressed: true,
    value: inputValue,
    onChange: e => setInputValue(e.target.value),
    min: 1,
    step: 1,
    isInvalid: !(0, _helpers.isValidNumber)(inputValue)
  }));
}
const MovingAveragePopup = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.basicExplanation",
    defaultMessage: "Moving average slides a window across the data and displays the average value. Moving average is supported only by date histograms."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.longerExplanation",
    defaultMessage: "To calculate the moving average, Lens uses the mean of the window and applies a skip policy for gaps.  For missing values, the bucket is skipped, and the calculation is performed on the next value."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.tableExplanation",
    defaultMessage: "For example, given the data [1, 2, 3, 4, 5, 6, 7, 8, 9, 10], you can calculate a simple moving average with a window size of 5:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "(1 + 2 + 3 + 4 + 5) / 5 = 3"), /*#__PURE__*/_react.default.createElement("li", null, "(2 + 3 + 4 + 5 + 6) / 5 = 4"), /*#__PURE__*/_react.default.createElement("li", null, "..."), /*#__PURE__*/_react.default.createElement("li", null, "(5 + 6 + 7 + 8 + 9) / 5 = 7")), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.windowLimitations",
    defaultMessage: "The window does not include the current value."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.windowInitialPartial",
    defaultMessage: "The window is partial until it reaches the requested number of items.  For example, with a window size of 5:"
  })), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, "(1 + 2) / 2 = 1.5"), /*#__PURE__*/_react.default.createElement("li", null, "(1 + 2 + 3) / 3 = 2"), /*#__PURE__*/_react.default.createElement("li", null, "(1 + 2 + 3 + 4) / 4 = 2.5"), /*#__PURE__*/_react.default.createElement("li", null, "(1 + 2 + 3 + 4 + 5) / 5 = 3")), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.movingAverage.limitations",
    defaultMessage: "The first moving average value starts at the second item."
  })));
};