"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cumulativeSumOperation = void 0;
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _helpers = require("../helpers");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ofName = (0, _utils.buildLabelFunction)(name => {
  return _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSumOf', {
    defaultMessage: 'Cumulative sum of {name}',
    values: {
      name: name !== null && name !== void 0 ? name : _i18n.i18n.translate('xpack.lens.indexPattern.incompleteOperation', {
        defaultMessage: '(incomplete)'
      })
    }
  });
});
const cumulativeSumOperation = {
  type: 'cumulative_sum',
  priority: 1,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSum', {
    defaultMessage: 'Cumulative sum'
  }),
  input: 'fullReference',
  selectionStyle: 'field',
  requiredReferences: [{
    input: ['field', 'managedReference'],
    specificOperations: ['count', 'sum'],
    validateMetadata: (meta, operationType, fieldName) => meta.dataType === 'number' && !meta.isBucketed &&
    // exclude value counts
    !(operationType === 'count' && fieldName !== _constants.DOCUMENT_FIELD_NAME)
  }],
  getPossibleOperation: indexPattern => {
    if ((0, _utils.hasDateField)(indexPattern)) {
      return {
        dataType: 'number',
        isBucketed: false,
        scale: 'ratio'
      };
    }
  },
  getDefaultLabel: (column, indexPattern, columns) => {
    var _indexPattern$getFiel;
    const ref = columns[column.references[0]];
    return ofName(ref && 'sourceField' in ref ? (_indexPattern$getFiel = indexPattern.getFieldByName(ref.sourceField)) === null || _indexPattern$getFiel === void 0 ? void 0 : _indexPattern$getFiel.displayName : undefined, undefined, column.timeShift);
  },
  toExpression: (layer, columnId) => {
    return (0, _utils.dateBasedOperationToExpression)(layer, columnId, 'cumulative_sum');
  },
  buildColumn: ({
    referenceIds,
    previousColumn,
    layer,
    indexPattern
  }, columnParams) => {
    var _indexPattern$getFiel2;
    const ref = layer.columns[referenceIds[0]];
    return {
      label: ofName(ref && 'sourceField' in ref ? (_indexPattern$getFiel2 = indexPattern.getFieldByName(ref.sourceField)) === null || _indexPattern$getFiel2 === void 0 ? void 0 : _indexPattern$getFiel2.displayName : undefined, undefined, previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      dataType: 'number',
      operationType: 'cumulative_sum',
      isBucketed: false,
      scale: 'ratio',
      timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
      filter: (0, _helpers.getFilter)(previousColumn, columnParams),
      references: referenceIds,
      params: (0, _helpers.getFormatFromPreviousColumn)(previousColumn)
    };
  },
  isTransferable: () => {
    return true;
  },
  getErrorMessage: (layer, columnId) => {
    return (0, _utils.getErrorsForDateReference)(layer, columnId, _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSum', {
      defaultMessage: 'Cumulative sum'
    }));
  },
  getDisabledStatus(indexPattern, layer, layerType) {
    var _checkForDateHistogra;
    const opName = _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSum', {
      defaultMessage: 'Cumulative sum'
    });
    if (layerType) {
      const dataLayerErrors = (0, _utils.checkForDataLayerType)(layerType, opName);
      if (dataLayerErrors) {
        return dataLayerErrors.join(', ');
      }
    }
    return (_checkForDateHistogra = (0, _utils.checkForDateHistogram)(layer, opName)) === null || _checkForDateHistogra === void 0 ? void 0 : _checkForDateHistogra.join(', ');
  },
  filterable: true,
  documentation: {
    section: 'calculation',
    signature: _i18n.i18n.translate('xpack.lens.indexPattern.cumulative_sum.signature', {
      defaultMessage: 'metric: number'
    }),
    description: _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSum.documentation.markdown', {
      defaultMessage: `
Calculates the cumulative sum of a metric over time, adding all previous values of a series to each value. To use this function, you need to configure a date histogram dimension as well.

This calculation will be done separately for separate series defined by filters or top values dimensions.

Example: Visualize the received bytes accumulated over time:
\`cumulative_sum(sum(bytes))\`
      `
    })
  },
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.cumulativeSum.documentation.quick', {
    defaultMessage: `
      The sum of all values as they grow over time.
      `
  }),
  shiftable: true
};
exports.cumulativeSumOperation = cumulativeSumOperation;