"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerPanel = LayerPanel;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _dataview_picker = require("../../shared_components/dataview_picker/dataview_picker");
var _utils = require("./utils");
var _sampling_icon = require("./sampling_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerPanel({
  state,
  layerId,
  onChangeIndexPattern,
  dataViews
}) {
  const layer = state.layers[layerId];
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const indexPattern = dataViews.indexPatterns[layer.indexPatternId];
  const notFoundTitleLabel = _i18n.i18n.translate('xpack.lens.layerPanel.missingDataView', {
    defaultMessage: 'Data view not found'
  });
  const indexPatternRefs = dataViews.indexPatternRefs.map(ref => {
    var _dataViews$indexPatte, _dataViews$indexPatte2;
    const isPersisted = (_dataViews$indexPatte = (_dataViews$indexPatte2 = dataViews.indexPatterns[ref.id]) === null || _dataViews$indexPatte2 === void 0 ? void 0 : _dataViews$indexPatte2.isPersisted) !== null && _dataViews$indexPatte !== void 0 ? _dataViews$indexPatte : true;
    return {
      ...ref,
      isAdhoc: !isPersisted
    };
  });
  const samplingValue = (0, _utils.getSamplingValue)(layer);
  const extraIconLabelProps = samplingValue !== 1 ? {
    icon: {
      component: /*#__PURE__*/_react.default.createElement(_sampling_icon.RandomSamplingIcon, {
        color: euiTheme.colors.disabledText,
        fill: "currentColor"
      }),
      value: `${samplingValue * 100}%`,
      tooltipValue: _i18n.i18n.translate('xpack.lens.indexPattern.randomSamplingInfo', {
        defaultMessage: '{value}% sampling',
        values: {
          value: samplingValue * 100
        }
      }),
      'data-test-subj': 'lnsChangeIndexPatternSamplingInfo'
    }
  } : {};
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_dataview_picker.ChangeIndexPattern, {
    "data-test-subj": "indexPattern-switcher",
    trigger: {
      label: (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.name) || notFoundTitleLabel,
      title: (indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.title) || notFoundTitleLabel,
      'data-test-subj': 'lns_layerIndexPatternLabel',
      size: 's',
      fontWeight: 'normal',
      ...extraIconLabelProps
    },
    indexPatternId: layer.indexPatternId,
    indexPatternRefs: indexPatternRefs,
    isMissingCurrent: !indexPattern,
    onChangeIndexPattern: onChangeIndexPattern
  }));
}