"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettingsPanel = LayerSettingsPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./utils");
var _shared_components = require("../../shared_components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const samplingValues = [0.00001, 0.0001, 0.001, 0.01, 0.1, 1];
/**
 * Stub for a shared component
 */
function SamplingSlider({
  values,
  currentValue,
  disabled,
  disabledReason,
  onChange,
  'data-test-subj': dataTestSubj
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const samplingIndex = values.findIndex(v => v === currentValue);
  const currentSamplingIndex = samplingIndex > -1 ? samplingIndex : values.length - 1;
  return /*#__PURE__*/_react2.default.createElement(_shared_components.TooltipWrapper, {
    tooltipContent: disabledReason,
    condition: disabled,
    delay: "regular",
    display: "block"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: disabled ? euiTheme.colors.disabledText : euiTheme.colors.subduedText,
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.randomSampling.performanceLabel",
    defaultMessage: "Performance"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiRange, {
    "data-test-subj": dataTestSubj,
    value: currentSamplingIndex,
    disabled: disabled,
    onChange: e => {
      onChange(values[Number(e.currentTarget.value)]);
    },
    showInput: false,
    showRange: false,
    showTicks: true,
    step: 1,
    min: 0,
    max: values.length - 1,
    ticks: values.map((v, i) => ({
      label: `${v * 100}%`.slice(Number.isInteger(v * 100) ? 0 : 1),
      value: i
    }))
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: disabled ? euiTheme.colors.disabledText : euiTheme.colors.subduedText,
    size: "xs"
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.randomSampling.accuracyLabel",
    defaultMessage: "Accuracy"
  })))));
}
function LayerSettingsPanel({
  state,
  setState,
  layerId
}) {
  const isSamplingValueDisabled = !(0, _utils.isSamplingValueEnabled)(state.layers[layerId]);
  const currentValue = isSamplingValueDisabled ? samplingValues[samplingValues.length - 1] : state.layers[layerId].sampling;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    "data-test-subj": "lns-indexPattern-random-sampling-row",
    fullWidth: true,
    helpText: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react2.default.createElement("p", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.randomSampling.help",
      defaultMessage: "Lower sampling percentages increases the performance, but lowers the accuracy. Lower sampling percentages are best for large datasets. {link}",
      values: {
        link: /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
          href: "https://www.elastic.co/guide/en/elasticsearch/reference/master/search-aggregations-random-sampler-aggregation.html",
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.lens.indexPattern.randomSampling.learnMore",
          defaultMessage: "View documentation"
        }))
      }
    }))),
    label: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.label', {
      defaultMessage: 'Sampling'
    }), ' ', /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.experimentalLabel', {
        defaultMessage: 'Technical preview'
      })
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
      css: (0, _react.css)`
                vertical-align: middle;
              `,
      iconType: "beaker",
      label: _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.experimentalLabel', {
        defaultMessage: 'Technical preview'
      }),
      size: "s"
    })))
  }, /*#__PURE__*/_react2.default.createElement(SamplingSlider, {
    disabled: isSamplingValueDisabled,
    disabledReason: _i18n.i18n.translate('xpack.lens.indexPattern.randomSampling.disabledMessage', {
      defaultMessage: 'In order to select a reduced sampling percentage, you must remove any maximum or minimum functions applied on this layer.'
    }),
    values: samplingValues,
    currentValue: currentValue,
    "data-test-subj": "lns-indexPattern-random-sampling-slider",
    onChange: newSamplingValue => {
      setState({
        ...state,
        layers: {
          ...state.layers,
          [layerId]: {
            ...state.layers[layerId],
            sampling: newSamplingValue
          }
        }
      });
    }
  }));
}