"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelector = FormatSelector;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _helpers = require("../operations/definitions/helpers");
var _shared_components = require("../../../shared_components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedFormats = {
  number: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.numberFormatLabel', {
      defaultMessage: 'Number'
    })
  },
  percent: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.percentFormatLabel', {
      defaultMessage: 'Percent'
    })
  },
  bytes: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bytesFormatLabel', {
      defaultMessage: 'Bytes (1024)'
    })
  },
  bits: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bitsFormatLabel', {
      defaultMessage: 'Bits (1000)'
    }),
    defaultDecimals: 0
  }
};
const defaultOption = {
  value: '',
  label: _i18n.i18n.translate('xpack.lens.indexPattern.defaultFormatLabel', {
    defaultMessage: 'Default'
  })
};
const singleSelectionOption = {
  asPlainText: true
};
const label = _i18n.i18n.translate('xpack.lens.indexPattern.columnFormatLabel', {
  defaultMessage: 'Value format'
});
const decimalsLabel = _i18n.i18n.translate('xpack.lens.indexPattern.decimalPlacesLabel', {
  defaultMessage: 'Decimals'
});
const suffixLabel = _i18n.i18n.translate('xpack.lens.indexPattern.suffixLabel', {
  defaultMessage: 'Suffix'
});
const RANGE_MIN = 0;
const RANGE_MAX = 15;
function FormatSelector(props) {
  var _selectedColumn$param, _currentFormat$params, _currentFormat$params2, _currentFormat$params3, _currentFormat$params4, _props$options;
  const {
    selectedColumn,
    onChange
  } = props;
  const currentFormat = (0, _helpers.isColumnFormatted)(selectedColumn) ? (_selectedColumn$param = selectedColumn.params) === null || _selectedColumn$param === void 0 ? void 0 : _selectedColumn$param.format : undefined;
  const [decimals, setDecimals] = (0, _react.useState)((_currentFormat$params = currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params2 = currentFormat.params) === null || _currentFormat$params2 === void 0 ? void 0 : _currentFormat$params2.decimals) !== null && _currentFormat$params !== void 0 ? _currentFormat$params : 2);
  const onChangeSuffix = (0, _react.useCallback)(suffix => {
    if (!currentFormat) {
      return;
    }
    onChange({
      id: currentFormat.id,
      params: {
        ...currentFormat.params,
        suffix
      }
    });
  }, [currentFormat, onChange]);
  const {
    handleInputChange: setSuffix,
    inputValue: suffix
  } = (0, _shared_components.useDebouncedValue)({
    onChange: onChangeSuffix,
    value: (_currentFormat$params3 = currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params4 = currentFormat.params) === null || _currentFormat$params4 === void 0 ? void 0 : _currentFormat$params4.suffix) !== null && _currentFormat$params3 !== void 0 ? _currentFormat$params3 : ''
  }, {
    allowFalsyValue: true
  });
  const selectedFormat = currentFormat !== null && currentFormat !== void 0 && currentFormat.id ? supportedFormats[currentFormat.id] : undefined;
  const stableOptions = (0, _react.useMemo)(() => [defaultOption, ...Object.entries(supportedFormats).map(([id, format]) => {
    var _format$title;
    return {
      value: id,
      label: (_format$title = format.title) !== null && _format$title !== void 0 ? _format$title : id
    };
  })], []);
  const onChangeWrapped = (0, _react.useCallback)(choices => {
    if (choices.length === 0) {
      return;
    }
    if (!choices[0].value) {
      onChange();
      return;
    }
    const id = choices[0].value;
    const defaultDecimals = supportedFormats[id].defaultDecimals;
    onChange({
      id: choices[0].value,
      params: {
        decimals: defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals
      }
    });
    setDecimals(defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals);
  }, [onChange, decimals]);
  const currentOption = (0, _react.useMemo)(() => {
    var _selectedFormat$title;
    return currentFormat ? [{
      value: currentFormat.id,
      label: (_selectedFormat$title = selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title) !== null && _selectedFormat$title !== void 0 ? _selectedFormat$title : currentFormat.id
    }] : [defaultOption];
  }, [currentFormat, selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "columnCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "indexPattern-dimension-format",
    "aria-label": label,
    singleSelection: singleSelectionOption,
    options: stableOptions,
    selectedOptions: currentOption,
    onChange: onChangeWrapped
  }), currentFormat && !((_props$options = props.options) !== null && _props$options !== void 0 && _props$options.disableExtraOptions) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    showInput: "inputWithPopover",
    value: decimals,
    min: RANGE_MIN,
    max: RANGE_MAX,
    onChange: e => {
      const value = Number(e.currentTarget.value);
      setDecimals(value);
      const validatedValue = Math.min(RANGE_MAX, Math.max(RANGE_MIN, value));
      onChange({
        id: currentFormat.id,
        params: {
          ...currentFormat.params,
          decimals: validatedValue
        }
      });
    },
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    compressed: true,
    fullWidth: true,
    prepend: decimalsLabel,
    "aria-label": decimalsLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: suffix,
    onChange: e => {
      setSuffix(e.currentTarget.value);
    },
    "data-test-subj": "indexPattern-dimension-formatSuffix",
    compressed: true,
    fullWidth: true,
    prepend: suffixLabel,
    "aria-label": suffixLabel
  })) : null)));
}