"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldSelect = FieldSelect;
require("./field_select.scss");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-field-list-plugin/public");
var _field_picker = require("../../../shared_components/field_picker");
var _shared_components = require("../../../shared_components");
var _pure_utils = require("../pure_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldSelect({
  currentIndexPattern,
  incompleteOperation,
  selectedOperationType,
  selectedField,
  operationByField,
  onChoose,
  onDeleteColumn,
  fieldIsInvalid,
  markAllFieldsCompatible,
  ['data-test-subj']: dataTestSub
}) {
  var _ref, _currentIndexPattern$5;
  const {
    hasFieldData
  } = (0, _public.useExistingFieldsReader)();
  const memoizedFieldOptions = (0, _react.useMemo)(() => {
    const fields = [...operationByField.keys()].sort();
    const currentOperationType = incompleteOperation !== null && incompleteOperation !== void 0 ? incompleteOperation : selectedOperationType;
    function isCompatibleWithCurrentOperation(fieldName) {
      return !currentOperationType || operationByField.get(fieldName).has(currentOperationType);
    }
    const [specialFields, normalFields] = (0, _lodash.partition)(fields, field => {
      var _currentIndexPattern$;
      return ((_currentIndexPattern$ = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$ === void 0 ? void 0 : _currentIndexPattern$.type) === 'document';
    });
    function containsData(fieldName) {
      return (0, _shared_components.fieldContainsData)(fieldName, currentIndexPattern, hasFieldData);
    }
    function fieldNamesToOptions(items) {
      return items.filter(field => {
        var _currentIndexPattern$2;
        return (_currentIndexPattern$2 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$2 === void 0 ? void 0 : _currentIndexPattern$2.displayName;
      }).map(field => {
        var _currentIndexPattern$3;
        const compatible = markAllFieldsCompatible || isCompatibleWithCurrentOperation(field) ? 1 : 0;
        const exists = containsData(field);
        const fieldInstance = currentIndexPattern.getFieldByName(field);
        return {
          label: (_currentIndexPattern$3 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$3 === void 0 ? void 0 : _currentIndexPattern$3.displayName,
          value: {
            type: 'field',
            field,
            dataType: fieldInstance ? (0, _pure_utils.getFieldType)(fieldInstance) : undefined,
            // Use the operation directly, or choose the first compatible operation.
            // All fields are guaranteed to have at least one operation because they
            // won't appear in the list otherwise
            operationType: currentOperationType && isCompatibleWithCurrentOperation(field) ? currentOperationType : operationByField.get(field).values().next().value // TODO let's remove these non-null assertion, they are very dangerous
          },

          exists,
          compatible,
          'data-test-subj': `lns-fieldOption${compatible ? '' : 'Incompatible'}-${field}`
        };
      }).sort((a, b) => b.compatible - a.compatible);
    }
    const [metaFields, nonMetaFields] = (0, _lodash.partition)(normalFields, field => {
      var _currentIndexPattern$4;
      return (_currentIndexPattern$4 = currentIndexPattern.getFieldByName(field)) === null || _currentIndexPattern$4 === void 0 ? void 0 : _currentIndexPattern$4.meta;
    });
    const [availableFields, emptyFields] = (0, _lodash.partition)(nonMetaFields, containsData);
    const constructFieldsOptions = (fieldsArr, label) => fieldsArr.length > 0 && {
      label,
      options: fieldNamesToOptions(fieldsArr)
    };
    const availableFieldsOptions = constructFieldsOptions(availableFields, _i18n.i18n.translate('xpack.lens.indexPattern.availableFieldsLabel', {
      defaultMessage: 'Available fields'
    }));
    const emptyFieldsOptions = constructFieldsOptions(emptyFields, _i18n.i18n.translate('xpack.lens.indexPattern.emptyFieldsLabel', {
      defaultMessage: 'Empty fields'
    }));
    const metaFieldsOptions = constructFieldsOptions(metaFields, _i18n.i18n.translate('xpack.lens.indexPattern.metaFieldsLabel', {
      defaultMessage: 'Meta fields'
    }));
    return [...fieldNamesToOptions(specialFields), availableFieldsOptions, emptyFieldsOptions, metaFieldsOptions].filter(Boolean);
  }, [incompleteOperation, selectedOperationType, currentIndexPattern, operationByField, hasFieldData, markAllFieldsCompatible]);
  return /*#__PURE__*/_react.default.createElement(_field_picker.FieldPicker, {
    selectedOptions: selectedOperationType && selectedField ? [{
      label: (_ref = selectedOperationType && selectedField && ((_currentIndexPattern$5 = currentIndexPattern.getFieldByName(selectedField)) === null || _currentIndexPattern$5 === void 0 ? void 0 : _currentIndexPattern$5.displayName)) !== null && _ref !== void 0 ? _ref : selectedField,
      value: {
        type: 'field',
        field: selectedField
      }
    }] : [],
    options: memoizedFieldOptions,
    onChoose: choice => {
      if (choice && choice.field !== selectedField) {
        onChoose(choice);
      }
    },
    onDelete: onDeleteColumn,
    fieldIsInvalid: Boolean(incompleteOperation || fieldIsInvalid),
    "data-test-subj": dataTestSub !== null && dataTestSub !== void 0 ? dataTestSub : 'indexPattern-dimension-field'
  });
}