"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createChartInfoApi = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createChartInfoApi = async (dataViews, editorFrameService) => {
  const [visualizationMap, datasourceMap] = await Promise.all([editorFrameService.loadVisualizations(), editorFrameService.loadDatasources()]);
  return {
    async getChartInfo(vis) {
      var _visualizationMap$len, _visualizationMap$len2;
      const lensVis = vis;
      const activeDatasourceId = (0, _utils.getActiveDatasourceIdFromDoc)(lensVis);
      if (!activeDatasourceId || !(lensVis !== null && lensVis !== void 0 && lensVis.visualizationType)) {
        return undefined;
      }
      const docDatasourceState = lensVis === null || lensVis === void 0 ? void 0 : lensVis.state.datasourceStates[activeDatasourceId];
      const dataSourceInfo = await datasourceMap[activeDatasourceId].getDatasourceInfo(docDatasourceState, lensVis === null || lensVis === void 0 ? void 0 : lensVis.references, dataViews);
      const chartInfo = (_visualizationMap$len = (_visualizationMap$len2 = visualizationMap[lensVis.visualizationType]).getVisualizationInfo) === null || _visualizationMap$len === void 0 ? void 0 : _visualizationMap$len.call(_visualizationMap$len2, lensVis === null || lensVis === void 0 ? void 0 : lensVis.state.visualization);
      const layers = chartInfo === null || chartInfo === void 0 ? void 0 : chartInfo.layers.map(l => {
        const dataSource = dataSourceInfo.find(info => info.layerId === l.layerId);
        const updatedDimensions = l.dimensions.map(d => {
          return {
            ...d,
            ...(dataSource === null || dataSource === void 0 ? void 0 : dataSource.columns.find(c => c.id === d.id))
          };
        });
        return {
          ...l,
          dataView: dataSource === null || dataSource === void 0 ? void 0 : dataSource.dataView,
          dimensions: updatedDimensions
        };
      });
      return layers ? {
        layers,
        visualizationType: lensVis.visualizationType,
        filters: lensVis.state.filters,
        query: lensVis.state.query
      } : undefined;
    }
  };
};
exports.createChartInfoApi = createChartInfoApi;