"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSaveModalComponent = getSaveModalComponent;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const SaveModal = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('../save_modal_container'))));
function LoadingSpinnerWithOverlay() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
}
const LensSavedModalLazy = props => {
  return /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(LoadingSpinnerWithOverlay, null)
  }, /*#__PURE__*/_react.default.createElement(SaveModal, props));
};
function getSaveModalComponent(coreStart, startDependencies) {
  return props => {
    const [lensServices, setLensServices] = (0, _react.useState)();
    (0, _react.useEffect)(() => {
      async function loadLensService() {
        const {
          getLensServices,
          getLensAttributeService
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
        const lensServicesT = await getLensServices(coreStart, startDependencies, getLensAttributeService(coreStart, startDependencies));
        setLensServices(lensServicesT);
      }
      loadLensService();
    }, []);
    if (!lensServices) {
      return /*#__PURE__*/_react.default.createElement(LoadingSpinnerWithOverlay, null);
    }
    const {
      ContextProvider: PresentationUtilContext
    } = lensServices.presentationUtil;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(PresentationUtilContext, null, /*#__PURE__*/_react.default.createElement(LensSavedModalLazy, (0, _extends2.default)({}, props, {
      lensServices: lensServices
    }))));
  };
}