"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _tags_saved_object_save_modal_origin_wrapper = require("./tags_saved_object_save_modal_origin_wrapper");
var _tags_saved_object_save_modal_dashboard_wrapper = require("./tags_saved_object_save_modal_dashboard_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SaveModal = props => {
  const {
    originatingApp,
    savingToLibraryPermitted,
    savedObjectsTagging,
    tagsIds,
    savedObjectId,
    title,
    description,
    allowByValueEmbeddables,
    returnToOriginSwitchLabel,
    getAppNameFromId,
    onClose,
    onSave
  } = props;

  // Use the modal with return-to-origin features if we're in an app's edit flow or if by-value embeddables are disabled
  if (originatingApp || !allowByValueEmbeddables) {
    return /*#__PURE__*/_react.default.createElement(_tags_saved_object_save_modal_origin_wrapper.TagEnhancedSavedObjectSaveModalOrigin, {
      savedObjectsTagging: savedObjectsTagging,
      initialTags: tagsIds,
      originatingApp: originatingApp,
      onClose: onClose,
      onSave: saveProps => onSave(saveProps, {
        saveToLibrary: true
      }),
      getAppNameFromId: getAppNameFromId,
      documentInfo: {
        id: savedObjectId,
        title: title || '',
        description: description || ''
      },
      returnToOriginSwitchLabel: returnToOriginSwitchLabel,
      objectType: _i18n.i18n.translate('xpack.lens.app.saveModalType', {
        defaultMessage: 'Lens visualization'
      }),
      "data-test-subj": "lnsApp_saveModalOrigin"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_tags_saved_object_save_modal_dashboard_wrapper.TagEnhancedSavedObjectSaveModalDashboard, {
    savedObjectsTagging: savedObjectsTagging,
    initialTags: tagsIds,
    canSaveByReference: Boolean(savingToLibraryPermitted),
    onSave: saveProps => {
      const saveToLibrary = Boolean(saveProps.addToLibrary);
      onSave(saveProps, {
        saveToLibrary
      });
    },
    onClose: onClose,
    documentInfo: {
      // if the user cannot save to the library - treat this as a new document.
      id: savingToLibraryPermitted ? savedObjectId : undefined,
      title: title || '',
      description: description || ''
    },
    objectType: _i18n.i18n.translate('xpack.lens.app.saveModalType', {
      defaultMessage: 'Lens visualization'
    }),
    "data-test-subj": "lnsApp_saveModalDashboard"
  });
};
exports.SaveModal = SaveModal;