"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DownloadPanelContent = DownloadPanelContent;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DownloadPanelContent({
  isDisabled,
  onClick,
  warnings = []
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "kbnShareContextMenu__finalPanel",
    "data-test-subj": "shareReportingForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.application.csvPanelContent.generationDescription",
    defaultMessage: "Download the data displayed in the visualization."
  })), warnings.map((warning, i) => /*#__PURE__*/_react.default.createElement("p", {
    key: i
  }, warning))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isDisabled,
    fullWidth: true,
    fill: true,
    onClick: onClick,
    "data-test-subj": "lnsApp_downloadCSVButton",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.application.csvPanelContent.downloadButtonLabel",
    defaultMessage: "Export as CSV"
  })));
}