"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAgentIdRoute = exports.getAgentId = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAgentIdRoute = router => {
  router.get({
    path: _constants.AGENT_ID_ROUTE,
    validate: {
      query: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        index: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const client = (await context.core).elasticsearch.client.asCurrentUser;
    const {
      query,
      index
    } = request.query;
    try {
      const agentId = await getAgentId(client, query, index);
      return response.ok({
        body: {
          agentId
        }
      });
    } catch (err) {
      return response.badRequest(err.message);
    }
  });
};
exports.registerAgentIdRoute = registerAgentIdRoute;
const getAgentId = async (client, query, index) => {
  var _$_source$agent$id, _search$hits$hits, _search$hits$hits$, _search$hits$hits$$_s, _search$hits$hits$$_s2;
  const queryDSL = JSON.parse(query);
  const search = await client.search({
    index: [index],
    body: {
      query: queryDSL,
      size: 1
    }
  });
  const agentId = (_$_source$agent$id = (_search$hits$hits = search.hits.hits) === null || _search$hits$hits === void 0 ? void 0 : (_search$hits$hits$ = _search$hits$hits[0]) === null || _search$hits$hits$ === void 0 ? void 0 : (_search$hits$hits$$_s = _search$hits$hits$._source) === null || _search$hits$hits$$_s === void 0 ? void 0 : (_search$hits$hits$$_s2 = _search$hits$hits$$_s.agent) === null || _search$hits$hits$$_s2 === void 0 ? void 0 : _search$hits$hits$$_s2.id) !== null && _$_source$agent$id !== void 0 ? _$_source$agent$id : null;
  return agentId;
};
exports.getAgentId = getAgentId;