"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.KubernetesSecurityRoutes = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _constants = require("../../../common/constants");
var _percent_widget = require("../percent_widget");
var _count_widget = require("../count_widget");
var _hooks = require("../../hooks");
var _styles = require("./styles");
var _tree_view_container = require("../tree_view_container");
var _charts_toggle = require("../charts_toggle");
var _translations = require("../../../common/translations");
var _container_name_widget = require("../container_name_widget");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KubernetesSecurityRoutesComponent = ({
  filter,
  indexPattern,
  globalFilter,
  renderSessionsView
}) => {
  const [shouldHideCharts, setShouldHideCharts] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_HIDE_WIDGETS_KEY, false);
  const styles = (0, _styles.useStyles)();
  const lastUpdated = (0, _hooks.useLastUpdated)(globalFilter);
  const onReduceInteractiveAggs = (0, _react.useCallback)(result => result.buckets.reduce((groupedByKeyValue, aggregate) => {
    var _aggregate$count_by_a, _aggregate$count_by_a2;
    groupedByKeyValue[aggregate.key_as_string || aggregate.key.toString()] = (_aggregate$count_by_a = (_aggregate$count_by_a2 = aggregate.count_by_aggs) === null || _aggregate$count_by_a2 === void 0 ? void 0 : _aggregate$count_by_a2.value) !== null && _aggregate$count_by_a !== void 0 ? _aggregate$count_by_a : 0;
    return groupedByKeyValue;
  }, {}), []);
  const onReduceRootAggs = (0, _react.useCallback)(result => result.buckets.reduce((groupedByKeyValue, aggregate) => {
    if (aggregate.key.toString() === '0') {
      var _aggregate$count_by_a3, _aggregate$count_by_a4;
      groupedByKeyValue[aggregate.key] = (_aggregate$count_by_a3 = (_aggregate$count_by_a4 = aggregate.count_by_aggs) === null || _aggregate$count_by_a4 === void 0 ? void 0 : _aggregate$count_by_a4.value) !== null && _aggregate$count_by_a3 !== void 0 ? _aggregate$count_by_a3 : 0;
    } else {
      var _aggregate$count_by_a5, _aggregate$count_by_a6;
      groupedByKeyValue.nonRoot = (groupedByKeyValue.nonRoot || 0) + ((_aggregate$count_by_a5 = (_aggregate$count_by_a6 = aggregate.count_by_aggs) === null || _aggregate$count_by_a6 === void 0 ? void 0 : _aggregate$count_by_a6.value) !== null && _aggregate$count_by_a5 !== void 0 ? _aggregate$count_by_a5 : 0);
    }
    return groupedByKeyValue;
  }, {}), []);
  const handleToggleHideCharts = (0, _react.useCallback)(() => {
    setShouldHideCharts(!shouldHideCharts);
  }, [setShouldHideCharts, shouldHideCharts]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    strict: true,
    exact: true,
    path: _constants.KUBERNETES_PATH
  }, filter, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: styles.titleSection
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    css: styles.titleText
  }, _constants.KUBERNETES_TITLE, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _translations.BETA,
    size: "s",
    css: styles.betaBadge
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.titleActions
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.updatedAt
  }, lastUpdated), /*#__PURE__*/_react.default.createElement(_charts_toggle.ChartsToggle, {
    shouldHideCharts: shouldHideCharts,
    handleToggleHideCharts: handleToggleHideCharts
  }))), !shouldHideCharts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.widgetsGroup
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.leftWidgetsGroup
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.countWidgetsGroup
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_CLUSTERS,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_CLUSTERS,
    groupedBy: _constants.ORCHESTRATOR_CLUSTER_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_NAMESPACE,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NAMESPACE,
    groupedBy: _constants.ORCHESTRATOR_NAMESPACE
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_NODES,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NODES,
    groupedBy: _constants.CLOUD_INSTANCE_NAME
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_PODS,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_NODES,
    groupedBy: _constants.ORCHESTRATOR_RESOURCE_ID
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_count_widget.CountWidget, {
    title: _translations.COUNT_WIDGET_CONTAINER_IMAGES,
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    widgetKey: _constants.COUNT_WIDGET_KEY_CONTAINER_IMAGES,
    groupedBy: _constants.CONTAINER_IMAGE_NAME
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: styles.widgetsBottomSpacing
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_percent_widget.PercentWidget, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: styles.percentageChartTitle
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.kubernetesSecurity.sessionChart.title",
      defaultMessage: "Session interactivity"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.kubernetesSecurity.sessionChart.tooltip",
        defaultMessage: "Interactive sessions have a controlling terminal and often imply that a human is entering the commands."
      })
    })),
    widgetKey: "sessionsPercentage",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    dataValueMap: {
      true: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.sessionChart.interactive', {
          defaultMessage: 'Interactive'
        }),
        fieldName: _constants.ENTRY_LEADER_INTERACTIVE,
        color: _uiTheme.euiThemeVars.euiColorVis0
      },
      false: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.sessionChart.nonInteractive', {
          defaultMessage: 'Non-interactive'
        }),
        fieldName: _constants.ENTRY_LEADER_INTERACTIVE,
        color: _uiTheme.euiThemeVars.euiColorVis1,
        shouldHideFilter: true
      }
    },
    groupedBy: _constants.ENTRY_LEADER_INTERACTIVE,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID,
    onReduce: onReduceInteractiveAggs
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_percent_widget.PercentWidget, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      css: styles.percentageChartTitle
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.kubernetesSecurity.entryUserChart.title",
      defaultMessage: "Entry session users"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.kubernetesSecurity.entryUserChart.tooltip",
        defaultMessage: "The entry session user is the initial Linux user associated with the session. This user may be set from authentication of a remote login or automatically for service sessions started by init."
      })
    })),
    widgetKey: "rootLoginPercentage",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    dataValueMap: {
      '0': {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.entryUserChart.root', {
          defaultMessage: 'Root'
        }),
        fieldName: _constants.ENTRY_LEADER_USER_ID,
        color: _uiTheme.euiThemeVars.euiColorVis2
      },
      nonRoot: {
        name: _i18n.i18n.translate('xpack.kubernetesSecurity.entryUserChart.nonRoot', {
          defaultMessage: 'Non-root'
        }),
        fieldName: _constants.ENTRY_LEADER_USER_ID,
        color: _uiTheme.euiThemeVars.euiColorVis3,
        shouldHideFilter: true
      }
    },
    groupedBy: _constants.ENTRY_LEADER_USER_ID,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID,
    onReduce: onReduceRootAggs
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: styles.rightWidgetsGroup
  }, /*#__PURE__*/_react.default.createElement(_container_name_widget.ContainerNameWidget, {
    widgetKey: "containerNameSessions",
    indexPattern: indexPattern,
    globalFilter: globalFilter,
    groupedBy: _constants.CONTAINER_IMAGE_NAME,
    countBy: _constants.ENTRY_LEADER_ENTITY_ID
  })))), /*#__PURE__*/_react.default.createElement(_tree_view_container.TreeViewContainer, {
    globalFilter: globalFilter,
    renderSessionsView: renderSessionsView,
    indexPattern: indexPattern
  })));
};
const KubernetesSecurityRoutes = /*#__PURE__*/_react.default.memo(KubernetesSecurityRoutesComponent);
// eslint-disable-next-line import/no-default-export
exports.default = exports.KubernetesSecurityRoutes = KubernetesSecurityRoutes;