"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unhashUrl = exports.unhashQuery = exports.hashUrl = exports.hashQuery = void 0;
var _format = require("../../../common/state_management/format");
var _state_encoder = require("../state_encoder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const unhashQuery = createQueryMapper(_state_encoder.hashedStateToExpandedState);
exports.unhashQuery = unhashQuery;
const hashQuery = createQueryMapper(_state_encoder.expandedStateToHashedState);
exports.hashQuery = hashQuery;
const unhashUrl = createQueryReplacer(unhashQuery);
exports.unhashUrl = unhashUrl;
const hashUrl = createQueryReplacer(hashQuery);

// naive hack, but this allows to decouple these utils from AppState, GlobalState for now
// when removing AppState, GlobalState and migrating to IState containers,
// need to make sure that apps explicitly passing this allow-list to hash
exports.hashUrl = hashUrl;
const __HACK_HARDCODED_LEGACY_HASHABLE_PARAMS = ['_g', '_a', '_s'];
function createQueryMapper(queryParamMapper) {
  return (query, options = {
    hashableParams: __HACK_HARDCODED_LEGACY_HASHABLE_PARAMS
  }) => Object.fromEntries(Object.entries(query || {}).map(([name, value]) => {
    if (!options.hashableParams.includes(name)) return [name, value];
    return [name, queryParamMapper(value) || value];
  }));
}
function createQueryReplacer(queryMapper, options) {
  return url => (0, _format.replaceUrlHashQuery)(url, query => queryMapper(query, options));
}