"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.persistState = persistState;
exports.retrieveState = retrieveState;
var _i18n = require("@kbn/i18n");
var _state_hash = require("../../../common/state_management/state_hash");
var _hashed_item_store = require("../../storage/hashed_item_store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function retrieveState(stateHash) {
  const json = _hashed_item_store.hashedItemStore.getItem(stateHash);
  const throwUnableToRestoreUrlError = () => {
    throw new Error(_i18n.i18n.translate('kibana_utils.stateManagement.stateHash.unableToRestoreUrlErrorMessage', {
      defaultMessage: 'Unable to completely restore the URL, be sure to use the share functionality.'
    }));
  };
  if (json === null) {
    return throwUnableToRestoreUrlError();
  }
  try {
    return JSON.parse(json);
  } catch (e) {
    return throwUnableToRestoreUrlError();
  }
}
function persistState(state) {
  const json = JSON.stringify(state);
  const hash = (0, _state_hash.createStateHash)(json, _hashed_item_store.hashedItemStore.getItem.bind(_hashed_item_store.hashedItemStore));
  const isItemSet = _hashed_item_store.hashedItemStore.setItem(hash, json);
  if (isItemSet) return hash;
  // If we ran out of space trying to persist the state, notify the user.
  const message = _i18n.i18n.translate('kibana_utils.stateManagement.stateHash.unableToStoreHistoryInSessionErrorMessage', {
    defaultMessage: 'Kibana is unable to store history items in your session ' + `because it is full and there don't seem to be items any items safe ` + 'to delete.\n\n' + 'This can usually be fixed by moving to a fresh tab, but could ' + 'be caused by a larger issue. If you are seeing this message regularly, ' + 'please file an issue at {gitHubIssuesUrl}.',
    values: {
      gitHubIssuesUrl: 'https://github.com/elastic/kibana/issues'
    }
  });
  throw new Error(message);
}