"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStateHash = createStateHash;
exports.isStateHash = isStateHash;
var _cryptoBrowser = require("@kbn/crypto-browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// This prefix is used to identify hash strings that have been encoded in the URL.
const HASH_PREFIX = 'h@';
function isStateHash(str) {
  return String(str).indexOf(HASH_PREFIX) === 0;
}
function createStateHash(json, existingJsonProvider) {
  if (typeof json !== 'string') {
    throw new Error('createHash only accepts strings (JSON).');
  }
  const hash = new _cryptoBrowser.Sha256().update(json, 'utf8').digest('hex');
  let shortenedHash;

  // Shorten the hash to at minimum 7 characters. We just need to make sure that it either:
  // a) hasn't been used yet
  // b) or has been used already, but with the JSON we're currently hashing.
  for (let i = 7; i < hash.length; i++) {
    shortenedHash = hash.slice(0, i);
    const existingJson = existingJsonProvider ? existingJsonProvider(shortenedHash) : null;
    if (existingJson === null || existingJson === json) break;
  }
  return `${HASH_PREFIX}${shortenedHash}`;
}