"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIfMounted = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useIfMounted = () => {
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => () => {
    isMounted.current = false;
  }, []);
  const ifMounted = (0, _react.useCallback)(func => {
    if (isMounted.current && func) {
      func();
    }
  }, []);
  return ifMounted;
};
exports.useIfMounted = useIfMounted;