"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toMountPoint = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _theme = require("../theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * MountPoint converter for react nodes.
 *
 * @param node to get a mount point for
 */
const toMountPoint = (node, {
  theme$
} = {}) => {
  const content = theme$ ? /*#__PURE__*/_react.default.createElement(_theme.KibanaThemeProvider, {
    theme$: theme$
  }, node) : node;
  const mount = element => {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, content), element);
    return () => _reactDom.default.unmountComponentAtNode(element);
  };
  // only used for tests and snapshots serialization
  if (process.env.NODE_ENV !== 'production') {
    mount.__reactMount__ = node;
  }
  return mount;
};
exports.toMountPoint = toMountPoint;