"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MountPointPortal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Utility component to portal a part of a react application into the provided `MountPoint`.
 */
const MountPointPortal = ({
  children,
  setMountPoint
}) => {
  // state used to force re-renders when the element changes
  const [shouldRender, setShouldRender] = (0, _react.useState)(false);
  const el = (0, _react.useRef)();
  const ifMounted = (0, _utils.useIfMounted)();
  (0, _react.useEffect)(() => {
    setMountPoint(element => {
      ifMounted(() => {
        el.current = element;
        setShouldRender(true);
      });
      return () => {
        // the component can be unmounted from the dom before the portal target actually
        // calls the `unmount` function. This is a no-op but show a scary warning in the console
        // so we use a ifMounted effect to avoid it.
        ifMounted(() => {
          setShouldRender(false);
          el.current = undefined;
        });
      };
    });
    return () => {
      ifMounted(() => {
        setShouldRender(false);
        el.current = undefined;
      });
    };
  }, [setMountPoint]);
  if (shouldRender && el.current) {
    return /*#__PURE__*/_reactDom.default.createPortal( /*#__PURE__*/_react.default.createElement(MountPointPortalErrorBoundary, null, children), el.current);
  } else {
    return null;
  }
};
exports.MountPointPortal = MountPointPortal;
class MountPointPortalErrorBoundary extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      error: undefined
    });
  }
  static getDerivedStateFromError(error) {
    return {
      error
    };
  }
  componentDidCatch() {
    // nothing, will just rerender to display the error message
  }
  render() {
    if (this.state.error) {
      return /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('kibana-react.mountPointPortal.errorMessage', {
        defaultMessage: 'Error rendering portal content'
      }));
    }
    return this.props.children;
  }
}