"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEIGHTS = exports.ToolbarButton = exports.TOOLBAR_BUTTON_SIZES = exports.POSITIONS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./toolbar_button.scss");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const groupPositionToClassMap = {
  none: null,
  left: 'kbnToolbarButton--groupLeft',
  center: 'kbnToolbarButton--groupCenter',
  right: 'kbnToolbarButton--groupRight'
};
const POSITIONS = Object.keys(groupPositionToClassMap);
exports.POSITIONS = POSITIONS;
const WEIGHTS = ['normal', 'bold'];
exports.WEIGHTS = WEIGHTS;
const TOOLBAR_BUTTON_SIZES = ['s', 'm'];
exports.TOOLBAR_BUTTON_SIZES = TOOLBAR_BUTTON_SIZES;
const ToolbarButton = ({
  children,
  className,
  fontWeight = 'normal',
  size = 'm',
  hasArrow = true,
  groupPosition = 'none',
  dataTestSubj = '',
  ...rest
}) => {
  const classes = (0, _classnames.default)('kbnToolbarButton', groupPositionToClassMap[groupPosition], [`kbnToolbarButton--${fontWeight}`, `kbnToolbarButton--${size}`], className);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    "data-test-subj": dataTestSubj,
    className: classes,
    iconSide: "right",
    iconType: hasArrow ? 'arrowDown' : '',
    color: "text",
    contentProps: {
      className: 'kbnToolbarButton__content'
    },
    textProps: {
      className: 'kbnToolbarButton__text'
    }
  }, rest, {
    size: size
  }), children);
};
exports.ToolbarButton = ToolbarButton;