"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Route = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _context = require("../context");
var _use_execution_context = require("../use_execution_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * It's a wrapper around the react-router-dom Route component that inserts
 * MatchPropagator in every application route. It helps track all route changes
 * and send them to the execution context, later used to enrich APM
 * 'route-change' transactions.
 */
const Route = ({
  children,
  component: Component,
  render,
  ...rest
}) => {
  const component = (0, _react.useMemo)(() => {
    if (!Component) {
      return undefined;
    }
    return props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MatchPropagator, null), /*#__PURE__*/_react.default.createElement(Component, props));
  }, [Component]);
  if (component) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, (0, _extends2.default)({}, rest, {
      component: component
    }));
  }
  if (render) {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, (0, _extends2.default)({}, rest, {
      render: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MatchPropagator, null), render(props))
    }));
  }
  if (typeof children === 'function') {
    return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, (0, _extends2.default)({}, rest, {
      render: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(MatchPropagator, null), children(props))
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, rest, /*#__PURE__*/_react.default.createElement(MatchPropagator, null), children);
};
exports.Route = Route;
const MatchPropagator = () => {
  const {
    executionContext
  } = (0, _context.useKibana)().services;
  const match = (0, _reactRouterDom.useRouteMatch)();
  (0, _use_execution_context.useExecutionContext)(executionContext, {
    type: 'application',
    page: match.path,
    id: Object.keys(match.params).length > 0 ? JSON.stringify(match.params) : undefined
  });
  return null;
};