"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaceholderWidget = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _monaco = require("@kbn/monaco");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PlaceholderWidget {
  constructor(placeholderText, editor) {
    (0, _defineProperty2.default)(this, "domNode", void 0);
    this.placeholderText = placeholderText;
    this.editor = editor;
    editor.addContentWidget(this);
  }
  getId() {
    return 'KBN_CODE_EDITOR_PLACEHOLDER_WIDGET_ID';
  }
  getDomNode() {
    if (!this.domNode) {
      const domNode = document.createElement('div');
      domNode.innerText = this.placeholderText;
      domNode.className = 'kibanaCodeEditor__placeholderContainer';
      this.editor.applyFontInfo(domNode);
      this.domNode = domNode;
    }
    return this.domNode;
  }
  getPosition() {
    return {
      position: {
        column: 1,
        lineNumber: 1
      },
      preference: [_monaco.monaco.editor.ContentWidgetPositionPreference.EXACT]
    };
  }
  dispose() {
    this.editor.removeContentWidget(this);
  }
}
exports.PlaceholderWidget = PlaceholderWidget;