"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNavigateToUrlClickHandler = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const createNavigateToUrlClickHandler = ({
  container,
  navigateToUrl
}) => {
  return e => {
    if (container == null) {
      return;
    }
    // see https://github.com/DefinitelyTyped/DefinitelyTyped/pull/12239
    const target = e.target;
    const link = (0, _utils.getClosestLink)(target, container);
    if (!link) {
      return;
    }
    if (link.href && (
    // ignore links with empty hrefs
    link.target === '' || link.target === '_self') &&
    // ignore links having a target
    e.button === 0 &&
    // ignore everything but left clicks
    !e.defaultPrevented &&
    // ignore default prevented events
    !(0, _utils.hasActiveModifierKey)(e) // ignore clicks with modifier keys
    ) {
      e.preventDefault();
      navigateToUrl(link.href);
    }
  };
};
exports.createNavigateToUrlClickHandler = createNavigateToUrlClickHandler;