"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaOverviewPlugin = void 0;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _operators = require("rxjs/operators");
var _public = require("@kbn/core/public");
var _common = require("../common");
var _ui_metric = require("./lib/ui_metric");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class KibanaOverviewPlugin {
  setup(core, {
    home,
    usageCollection
  }) {
    if (usageCollection) {
      (0, _ui_metric.init)(usageCollection.reportUiCounter);
    }
    const appUpdater$ = (0, _rxjs.from)(core.getStartServices()).pipe((0, _operators.switchMap)(([coreDeps]) => coreDeps.chrome.navLinks.getNavLinks$()), (0, _operators.map)(navLinks => {
      const hasKibanaApp = Boolean(navLinks.find(({
        id,
        category,
        hidden
      }) => !hidden && (category === null || category === void 0 ? void 0 : category.id) === 'kibana' && id !== _common.PLUGIN_ID));
      return hasKibanaApp;
    }), (0, _operators.distinct)(), (0, _operators.map)(hasKibanaApp => {
      return () => {
        if (!hasKibanaApp) {
          return {
            status: _public.AppStatus.inaccessible,
            navLinkStatus: _public.AppNavLinkStatus.hidden
          };
        } else {
          return {
            status: _public.AppStatus.accessible,
            navLinkStatus: _public.AppNavLinkStatus.default
          };
        }
      };
    }));

    // Register an application into the side navigation menu
    core.application.register({
      category: _public.DEFAULT_APP_CATEGORIES.kibana,
      id: _common.PLUGIN_ID,
      title: _common.PLUGIN_NAME,
      euiIconType: _common.PLUGIN_ICON,
      order: 1,
      updater$: appUpdater$,
      appRoute: _common.PLUGIN_PATH,
      async mount(params) {
        // Load application bundle
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        // Get start services as specified in kibana.json
        const [coreStart, depsStart] = await core.getStartServices();

        // Render the application
        return renderApp(coreStart, depsStart, params);
      }
    });
    if (home) {
      home.featureCatalogue.registerSolution({
        id: 'kibana',
        title: _i18n.i18n.translate('kibanaOverview.kibana.solution.title', {
          defaultMessage: 'Analytics'
        }),
        description: _i18n.i18n.translate('kibanaOverview.kibana.solution.description', {
          defaultMessage: 'Explore, visualize, and analyze your data using a powerful suite of analytical tools and applications.'
        }),
        icon: 'logoKibana',
        path: _common.PLUGIN_PATH,
        order: 400
      });
    }

    // Return methods that should be available to other plugins
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.KibanaOverviewPlugin = KibanaOverviewPlugin;