"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useVerification = exports.VerificationProvider = void 0;
var _eui = require("@elastic/eui");
var _constate = _interopRequireDefault(require("constate"));
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _use_kibana = require("./use_kibana");
var _verification_code_form = require("./verification_code_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const [OuterVerificationProvider, useVerification] = (0, _constate.default)(({
  defaultCode
}) => {
  const codeRef = (0, _react.useRef)(defaultCode);
  const [status, setStatus] = (0, _react.useState)('unknown');
  return {
    status,
    setStatus,
    getCode() {
      return codeRef.current;
    },
    setCode(code) {
      codeRef.current = code;
    }
  };
});
exports.useVerification = useVerification;
const InnerVerificationProvider = ({
  children
}) => {
  const {
    http
  } = (0, _use_kibana.useKibana)();
  const {
    status,
    setStatus,
    setCode
  } = useVerification();
  (0, _react.useEffect)(() => {
    return http.intercept({
      responseError: error => {
        var _error$response;
        if (((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 403) {
          setStatus('unverified');
          setCode(undefined);
        }
      }
    });
  }, [http]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status === 'unverified' && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => setStatus('unknown'),
    maxWidth: _uiTheme.euiThemeVars.euiBreakpoints.s
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_verification_code_form.VerificationCodeForm, {
    onSuccess: values => {
      setStatus('verified');
      setCode(values.code);
    }
  }))), children);
};
const VerificationProvider = ({
  defaultCode,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(OuterVerificationProvider, {
    defaultCode: defaultCode
  }, /*#__PURE__*/_react.default.createElement(InnerVerificationProvider, null, children));
};
exports.VerificationProvider = VerificationProvider;